/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionContainsUrlInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("collection.contains.url.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CollectionContainsUrlInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        ClassType type = (ClassType)((Object)infos[0]);
        String string = InspectionGadgetsBundle.message("collection.contains.url.problem.decriptor", new Object[]{type});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CollectionContainsUrlInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CollectionContainsUrlVisitor();
    }

    static enum ClassType {
        SET,
        MAP,
        OTHER;


        public String toString() {
            String string = super.toString();
            return string.charAt(0) + string.substring(1).toLowerCase();
        }
    }

    private static class UrlAddedVisitor
    extends JavaRecursiveElementVisitor {
        private boolean urlAdded = false;
        private final PsiVariable variable;
        private final ClassType collectionType;

        UrlAddedVisitor(PsiVariable variable, ClassType collectionType) {
            this.variable = variable;
            this.collectionType = collectionType;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.urlAdded) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            String methodName = methodExpression.getReferenceName();
            if (this.collectionType == ClassType.SET && !"add".equals(methodName)) {
                return;
            }
            if (this.collectionType == ClassType.MAP && !"put".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType == null || !argumentType.equalsToText("java.net.URL")) {
                return;
            }
            PsiElement element = referenceExpression.resolve();
            if (!this.variable.equals(element)) {
                return;
            }
            this.urlAdded = true;
        }

        public boolean isUrlAdded() {
            return this.urlAdded;
        }
    }

    private static class CollectionContainsUrlVisitor
    extends BaseInspectionVisitor {
        private CollectionContainsUrlVisitor() {
        }

        public void visitVariable(PsiVariable variable) {
            super.visitVariable(variable);
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType type = typeElement.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = typeElement.getInnermostComponentReferenceElement();
            if (referenceElement == null) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            ClassType collectionType = CollectionContainsUrlVisitor.getClassType(aClass);
            if (collectionType == ClassType.OTHER) {
                return;
            }
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            if (parameterList == null || parameterList.getTypeParameterElements().length == 0) {
                PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiMember.class);
                if (member == null) {
                    return;
                }
                UrlAddedVisitor visitor = new UrlAddedVisitor(variable, collectionType);
                member.accept((PsiElementVisitor)visitor);
                if (visitor.isUrlAdded()) {
                    this.registerVariableError(variable, new Object[]{collectionType});
                }
                return;
            }
            PsiType[] typeArguments = parameterList.getTypeArguments();
            boolean containsUrl = false;
            for (PsiType typeArgument : typeArguments) {
                if (!typeArgument.equalsToText("java.net.URL")) continue;
                containsUrl = true;
                break;
            }
            if (!containsUrl) {
                return;
            }
            this.registerVariableError(variable, new Object[]{collectionType});
        }

        private static ClassType getClassType(@Nullable PsiClass aClass) {
            return CollectionContainsUrlVisitor.isMapOrSet(aClass, new HashSet<PsiClass>());
        }

        private static ClassType isMapOrSet(@Nullable PsiClass aClass, Set<PsiClass> visitedClasses) {
            PsiClass[] supers;
            if (aClass == null) {
                return ClassType.OTHER;
            }
            if (!visitedClasses.add(aClass)) {
                return ClassType.OTHER;
            }
            String className = aClass.getQualifiedName();
            if ("java.util.Set".equals(className)) {
                return ClassType.SET;
            }
            if ("java.util.Map".equals(className)) {
                return ClassType.MAP;
            }
            for (PsiClass aSuper : supers = aClass.getSupers()) {
                ClassType classType = CollectionContainsUrlVisitor.isMapOrSet(aSuper, visitedClasses);
                if (classType == ClassType.OTHER) continue;
                return classType;
            }
            return ClassType.OTHER;
        }
    }
}

