/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.config.GitConfigUtil;
import git4idea.rebase.GitRebaseEntry;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class GitInteractiveRebaseFile {
    @NonNls
    private static final String CYGDRIVE_PREFIX = "/cygdrive/";
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final String myFile;

    GitInteractiveRebaseFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull String rebaseFilePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitInteractiveRebaseFile", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitInteractiveRebaseFile", "<init>"));
        }
        if (rebaseFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rebaseFilePath", "git4idea/rebase/GitInteractiveRebaseFile", "<init>"));
        }
        this.myProject = project;
        this.myRoot = root;
        this.myFile = GitInteractiveRebaseFile.adjustFilePath(rebaseFilePath);
    }

    @NotNull
    public List<GitRebaseEntry> load() throws IOException, NoopException {
        String encoding = GitConfigUtil.getLogEncoding(this.myProject, this.myRoot);
        ArrayList entries = ContainerUtil.newArrayList();
        StringScanner s = new StringScanner(FileUtil.loadFile((File)new File(this.myFile), (String)encoding));
        boolean noop = false;
        while (s.hasMoreData()) {
            if (s.isEol() || s.startsWith('#')) {
                s.nextLine();
                continue;
            }
            if (s.startsWith("noop")) {
                noop = true;
                s.nextLine();
                continue;
            }
            String action = s.spaceToken();
            String hash = s.spaceToken();
            String comment = s.line();
            entries.add(new GitRebaseEntry(action, hash, comment));
        }
        if (noop && entries.isEmpty()) {
            throw new NoopException();
        }
        ArrayList arrayList = entries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitInteractiveRebaseFile", "load"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(this.myFile));
        try {
            out.println("# rebase is cancelled");
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NotNull List<GitRebaseEntry> entries) throws IOException {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "git4idea/rebase/GitInteractiveRebaseFile", "save"));
        }
        String encoding = GitConfigUtil.getLogEncoding(this.myProject, this.myRoot);
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.myFile), encoding));
        try {
            for (GitRebaseEntry e : entries) {
                if (e.getAction() == GitRebaseEntry.Action.skip) continue;
                out.println(e.getAction().toString() + " " + e.getCommit() + " " + e.getSubject());
            }
        }
        finally {
            out.close();
        }
    }

    @NotNull
    private static String adjustFilePath(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/rebase/GitInteractiveRebaseFile", "adjustFilePath"));
        }
        if (SystemInfo.isWindows && file.startsWith(CYGDRIVE_PREFIX)) {
            int prefixSize = CYGDRIVE_PREFIX.length();
            String string = file.substring(prefixSize, prefixSize + 1) + ":" + file.substring(prefixSize + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitInteractiveRebaseFile", "adjustFilePath"));
            }
            return string;
        }
        String string = file;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitInteractiveRebaseFile", "adjustFilePath"));
        }
        return string;
    }

    static class NoopException
    extends Exception {
        NoopException() {
        }
    }
}

