/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.wizard.SmwConfirmationTable;
import com.android.tools.idea.sdk.wizard.SmwConfirmationTableModel;
import com.android.tools.idea.sdk.wizard.SmwState;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.Disposable;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmwConfirmationStep
extends TemplateWizardStep
implements Disposable {
    private final SmwState myWizardState;
    private JPanel myContentPanel;
    private JLabel myTextDescription;
    private JBLabel myLabelSdkPath;
    private JBTable myTable;
    private JLabel myErrorLabel;
    private SmwConfirmationTableModel myTableModel;
    private boolean myInitOnce;
    private boolean myInInit;

    public SmwConfirmationStep(@NotNull SmwState wizardState, @Nullable TemplateWizardStep.UpdateListener updateListener) {
        if (wizardState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardState", "com/android/tools/idea/sdk/wizard/SmwConfirmationStep", "<init>"));
        }
        super(wizardState, null, null, null, updateListener);
        this.myInitOnce = true;
        this.myWizardState = wizardState;
        this.$$$setupUI$$$();
    }

    public void dispose() {
    }

    @Override
    public JComponent getComponent() {
        return this.myContentPanel;
    }

    private void createUIComponents() {
        this.myTable = new SmwConfirmationTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _init() {
        if (this.myInInit) {
            return;
        }
        this.myInInit = true;
        try {
            if (this.myInitOnce) {
                this.myInitOnce = false;
                GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myContentPanel);
                super._init();
                SdkState sdkState = this.myWizardState.getSdkState();
                if (sdkState != null) {
                    AndroidSdkData sdkData = sdkState.getSdkData();
                    this.myLabelSdkPath.setText(sdkData.getLocalSdk().getLocation().getPath());
                }
                SmwConfirmationTableModel.LabelColumnInfo pkgColumn = new SmwConfirmationTableModel.LabelColumnInfo("Package");
                SmwConfirmationTableModel.InstallColumnInfo selColumn = new SmwConfirmationTableModel.InstallColumnInfo("Accept");
                this.myTableModel = new SmwConfirmationTableModel(pkgColumn, selColumn);
                this.myTable.setModel((TableModel)this.myTableModel);
                this.myTableModel.addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                        SmwConfirmationStep.this.fireStateChanged();
                    }
                });
            }
            this.myTableModel.fillModel(this.myWizardState.getSelectedActions());
            ListSelectionModel lsm = this.myTable.getSelectionModel();
            lsm.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SmwConfirmationStep.this.onTableSelection(e);
                }
            });
            this.onTableSelection(new ListSelectionEvent(lsm, lsm.getMinSelectionIndex(), lsm.getMaxSelectionIndex(), lsm.getValueIsAdjusting()));
        }
        finally {
            this.myInInit = false;
        }
    }

    @Override
    @NotNull
    protected JLabel getDescription() {
        JLabel jLabel = this.myErrorLabel;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/SmwConfirmationStep", "getDescription"));
        }
        return jLabel;
    }

    @Override
    @NotNull
    protected JLabel getError() {
        JLabel jLabel = this.myErrorLabel;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/SmwConfirmationStep", "getError"));
        }
        return jLabel;
    }

    public void _commit(boolean finishChosen) throws CommitStepException {
        super._commit(finishChosen);
    }

    private void onTableSelection(ListSelectionEvent e) {
        SmwConfirmationTableModel.LineInfo item;
        Object src = e.getSource();
        if (!(src instanceof ListSelectionModel) || e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)src;
        StringBuilder sb = new StringBuilder("<html>");
        SmwConfirmationTableModel.LineInfo lineInfo = item = lsm.isSelectionEmpty() ? null : this.myTableModel.getObjectAt(lsm.getMinSelectionIndex());
        if (item == null) {
            sb.append("Please select a package to see its details.");
        } else {
            switch (item.getType()) {
                case REMOVE: {
                    sb.append(item.getRemovedPkg().getLongDescription());
                    break;
                }
                case UPDATE: {
                    sb.append(item.getUpdatePkg().getLongDescription());
                    break;
                }
                case INSTALL: {
                    sb.append(item.getInstallNewPkg().getLongDescription());
                    break;
                }
                default: {
                    sb.append("Please select a package to see its details.");
                }
            }
        }
        sb.append("</html>");
        this.myTextDescription.setText(sb.toString().replace("\n", "<br/>\n"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("SDK Path:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myLabelSdkPath = jBLabel = new JBLabel();
        jBLabel.setText("<placeholder path>");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(200);
        jPanel.add((Component)jSplitPane, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 7, null, new Dimension(200, 200), null));
        this.myTextDescription = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        ((Component)jLabel2).setBackground(UIManager.getColor("TextPane.background"));
        jLabel2.setOpaque(true);
        jLabel2.setVerticalTextPosition(3);
        jLabel2.setVerticalAlignment(1);
        jSplitPane.setRightComponent(jLabel2);
        JBTable jBTable = this.myTable;
        jSplitPane.setLeftComponent((Component)jBTable);
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 2, 0, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

