/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.diagnostic.VMOptions;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.run.PluginRunConfiguration;

public class PluginConfigurationType
implements ConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactory(this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            PluginRunConfiguration runConfiguration = new PluginRunConfiguration(project, this, "");
            runConfiguration.VM_PARAMETERS = runConfiguration.VM_PARAMETERS == null ? PluginConfigurationType.this.getVmParameters() : runConfiguration.VM_PARAMETERS + PluginConfigurationType.this.getVmParameters();
            return runConfiguration;
        }

        public boolean isApplicable(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/run/PluginConfigurationType$1", "isApplicable"));
            }
            return ModuleUtil.hasModulesOfType((Project)project, (ModuleType)PluginModuleType.getInstance());
        }

        public boolean isConfigurationSingletonByDefault() {
            return true;
        }

        public RunConfiguration createConfiguration(String name, RunConfiguration template) {
            PluginRunConfiguration pluginRunConfiguration = (PluginRunConfiguration)template;
            if (pluginRunConfiguration.getModule() == null) {
                Collection modules = ModuleUtil.getModulesOfType((Project)pluginRunConfiguration.getProject(), (ModuleType)PluginModuleType.getInstance());
                pluginRunConfiguration.setModule((Module)ContainerUtil.getFirstItem((Collection)modules));
            }
            return super.createConfiguration(name, (RunConfiguration)pluginRunConfiguration);
        }
    };
    private String myVmParameters;

    public String getDisplayName() {
        return DevKitBundle.message("run.configuration.title", new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return DevKitBundle.message("run.configuration.type.description", new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.Nodes.Plugin;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @NotNull
    public String getId() {
        if ("#org.jetbrains.idea.devkit.run.PluginConfigurationType" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/run/PluginConfigurationType", "getId"));
        }
        return "#org.jetbrains.idea.devkit.run.PluginConfigurationType";
    }

    @NotNull
    private String getVmParameters() {
        if (this.myVmParameters == null) {
            String vmOptions;
            try {
                vmOptions = FileUtil.loadFile((File)new File(PathManager.getBinPath(), "idea.plugins.vmoptions")).replaceAll("\\s+", " ");
            }
            catch (IOException e) {
                vmOptions = VMOptions.read();
            }
            this.myVmParameters = vmOptions != null ? vmOptions.trim() : "";
        }
        String string = this.myVmParameters;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/run/PluginConfigurationType", "getVmParameters"));
        }
        return string;
    }
}

