/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.java.decompiler.modules.decompiler.LowBreakHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public class EliminateLoopsHelper {
    private static boolean eliminateLoopsRec(Statement stat) {
        for (Statement st : stat.getStats()) {
            if (!EliminateLoopsHelper.eliminateLoopsRec(st)) continue;
            return true;
        }
        return stat.type == 5 && EliminateLoopsHelper.isLoopRedundant((DoStatement)stat);
    }

    private static boolean isLoopRedundant(DoStatement loop) {
        Statement parentloop;
        if (loop.getLooptype() != 0) {
            return false;
        }
        for (parentloop = loop.getParent(); parentloop != null && parentloop.type != 5; parentloop = parentloop.getParent()) {
        }
        if (parentloop == null || parentloop.getBasichead() != loop.getBasichead()) {
            return false;
        }
        ArrayList<StatEdge> lstBreakEdges = new ArrayList<StatEdge>();
        for (StatEdge edge : loop.getLabelEdges()) {
            if (edge.getType() != 4) continue;
            lstBreakEdges.add(edge);
        }
        Statement loopcontent = loop.getFirst();
        boolean firstok = loopcontent.getAllSuccessorEdges().isEmpty();
        if (!firstok) {
            StatEdge edge = loopcontent.getAllSuccessorEdges().get(0);
            boolean bl = firstok = edge.closure == loop && edge.getType() == 4;
            if (firstok) {
                lstBreakEdges.remove(edge);
            }
        }
        if (!lstBreakEdges.isEmpty()) {
            if (firstok) {
                int i;
                Statement st2;
                HashMap<Integer, Boolean> statLabeled = new HashMap<Integer, Boolean>();
                ArrayList<Statement> lstEdgeClosures = new ArrayList<Statement>();
                for (StatEdge edge : lstBreakEdges) {
                    Statement minclosure = LowBreakHelper.getMinClosure(loopcontent, edge.getSource());
                    lstEdgeClosures.add(minclosure);
                }
                int precount = loop.isLabeled() ? 1 : 0;
                for (Statement st2 : lstEdgeClosures) {
                    if (statLabeled.containsKey(st2.id)) continue;
                    boolean btemp = st2.isLabeled();
                    precount += btemp ? 1 : 0;
                    statLabeled.put(st2.id, btemp);
                }
                for (i = 0; i < lstBreakEdges.size(); ++i) {
                    st2 = (Statement)lstEdgeClosures.get(i);
                    statLabeled.put(st2.id, LowBreakHelper.isBreakEdgeLabeled(((StatEdge)lstBreakEdges.get(i)).getSource(), st2) | (Boolean)statLabeled.get(st2.id));
                }
                for (i = 0; i < lstBreakEdges.size(); ++i) {
                    lstEdgeClosures.set(i, EliminateLoopsHelper.getMaxBreakLift((Statement)lstEdgeClosures.get(i), (StatEdge)lstBreakEdges.get(i), statLabeled, loop));
                }
                statLabeled.clear();
                for (Statement st2 : lstEdgeClosures) {
                    statLabeled.put(st2.id, st2.isLabeled());
                }
                for (int i2 = 0; i2 < lstBreakEdges.size(); ++i2) {
                    st2 = (Statement)lstEdgeClosures.get(i2);
                    statLabeled.put(st2.id, LowBreakHelper.isBreakEdgeLabeled(((StatEdge)lstBreakEdges.get(i2)).getSource(), st2) | statLabeled.get(st2.id));
                }
                int postcount = 0;
                for (Boolean val : statLabeled.values()) {
                    postcount += val != false ? 1 : 0;
                }
                if (precount <= postcount) {
                    return false;
                }
                for (int i3 = 0; i3 < lstBreakEdges.size(); ++i3) {
                    ((Statement)lstEdgeClosures.get(i3)).addLabeledEdge((StatEdge)lstBreakEdges.get(i3));
                }
            } else {
                return false;
            }
        }
        EliminateLoopsHelper.eliminateLoop(loop, parentloop);
        return true;
    }

    private static Statement getMaxBreakLift(Statement stat, StatEdge edge, HashMap<Integer, Boolean> statLabeled, Statement max) {
        Statement closure = stat;
        Statement newclosure = stat;
        while ((newclosure = EliminateLoopsHelper.getNextBreakLift(newclosure, edge, statLabeled, max)) != null) {
            closure = newclosure;
        }
        return closure;
    }

    private static Statement getNextBreakLift(Statement stat, StatEdge edge, HashMap<Integer, Boolean> statLabeled, Statement max) {
        for (Statement closure = stat.getParent(); closure != null && closure != max && !closure.containsStatementStrict(edge.getDestination()); closure = closure.getParent()) {
            boolean stat_labeled;
            boolean edge_labeled = LowBreakHelper.isBreakEdgeLabeled(edge.getSource(), closure);
            boolean bl = stat_labeled = statLabeled.containsKey(closure.id) ? statLabeled.get(closure.id).booleanValue() : closure.isLabeled();
            if (!stat_labeled && edge_labeled) continue;
            return closure;
        }
        return null;
    }

    private static void eliminateLoop(Statement loop, Statement parentloop) {
        ArrayList<StatEdge> lst = new ArrayList<StatEdge>(loop.getLabelEdges());
        for (StatEdge edge : lst) {
            loop.removePredecessor(edge);
            edge.getSource().changeEdgeNode(1, edge, parentloop);
            parentloop.addPredecessor(edge);
            parentloop.addLabeledEdge(edge);
        }
        Statement loopcontent = loop.getFirst();
        if (!loopcontent.getAllSuccessorEdges().isEmpty()) {
            loopcontent.removeSuccessor(loopcontent.getAllSuccessorEdges().get(0));
        }
        loop.getParent().replaceStatement(loop, loopcontent);
    }
}

