/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.Collection;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.TypeInfo;
import org.gradle.internal.typeconversion.UnsupportedNotationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypedNotationParser<N, T>
implements NotationParser<Object, T> {
    private final Class<N> typeToken;

    public TypedNotationParser(Class<N> typeToken) {
        assert (typeToken != null) : "typeToken cannot be null";
        this.typeToken = typeToken;
    }

    public TypedNotationParser(TypeInfo<N> typeToken) {
        assert (typeToken != null) : "typeToken cannot be null";
        this.typeToken = typeToken.getTargetType();
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        candidateFormats.add(String.format("Instances of %s.", this.typeToken.getSimpleName()));
    }

    @Override
    public T parseNotation(Object notation) {
        if (!this.typeToken.isInstance(notation)) {
            throw new UnsupportedNotationException(notation);
        }
        return this.parseType(this.typeToken.cast(notation));
    }

    protected abstract T parseType(N var1);
}

