/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.JUnit4OutputObjectRegistry;
import com.intellij.junit4.JUnit4ReflectionUtil;
import com.intellij.junit4.JUnit4TestResultsSender;
import com.intellij.junit4.JUnit4TestRunnerUtil;
import com.intellij.junit4.SMTestSender;
import com.intellij.rt.execution.junit.IDEAJUnitListener;
import com.intellij.rt.execution.junit.IdeaTestRunner;
import com.intellij.rt.execution.junit.JUnitStarter;
import com.intellij.rt.execution.junit.TimeSender;
import com.intellij.rt.execution.junit.TreeSender;
import com.intellij.rt.execution.junit.segments.OutputObjectRegistry;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import com.intellij.rt.execution.junit.segments.SegmentedOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.internal.requests.ClassRequest;
import org.junit.internal.requests.FilterRequest;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunListener;

public class JUnit4IdeaTestRunner
implements IdeaTestRunner {
    private RunListener myTestsListener;
    private OutputObjectRegistry myRegistry;
    static /* synthetic */ Class class$org$junit$internal$requests$FilterRequest;
    static /* synthetic */ Class class$org$junit$internal$requests$ClassRequest;

    public int startRunnerWithArgs(String[] args, ArrayList listeners, String name, boolean sendTree) {
        Request request = JUnit4TestRunnerUtil.buildRequest(args, name, sendTree);
        if (request == null) {
            return -1;
        }
        Runner testRunner = request.getRunner();
        try {
            Description description = testRunner.getDescription();
            if (description == null) {
                System.err.println("Nothing found to run. Runner " + testRunner.getClass().getName() + " provides no description.");
                return -1;
            }
            if (request instanceof ClassRequest) {
                description = JUnit4IdeaTestRunner.getSuiteMethodDescription(request, description);
            } else if (request instanceof FilterRequest) {
                description = JUnit4IdeaTestRunner.getFilteredDescription(request, description);
            }
            TreeSender.sendTree(this, description, sendTree);
        }
        catch (Exception e) {
            System.err.println("Internal Error occured.");
            e.printStackTrace(System.err);
        }
        try {
            JUnitCore runner = new JUnitCore();
            runner.addListener(this.myTestsListener);
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                final IDEAJUnitListener junitListener = (IDEAJUnitListener)Class.forName((String)iterator.next()).newInstance();
                runner.addListener(new RunListener(){

                    public void testStarted(Description description) throws Exception {
                        junitListener.testStarted(JUnit4ReflectionUtil.getClassName(description), JUnit4ReflectionUtil.getMethodName(description));
                    }

                    public void testFinished(Description description) throws Exception {
                        junitListener.testFinished(JUnit4ReflectionUtil.getClassName(description), JUnit4ReflectionUtil.getMethodName(description));
                    }
                });
            }
            long startTime = System.currentTimeMillis();
            Result result = runner.run(testRunner);
            long endTime = System.currentTimeMillis();
            long runTime = endTime - startTime;
            if (sendTree) {
                new TimeSender(this.myRegistry).printHeader(runTime);
            }
            if (!result.wasSuccessful()) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return -2;
        }
    }

    private static Description getFilteredDescription(Request request, Description description) throws NoSuchFieldException, IllegalAccessException {
        Field field;
        try {
            field = (class$org$junit$internal$requests$FilterRequest == null ? (class$org$junit$internal$requests$FilterRequest = JUnit4IdeaTestRunner.class$("org.junit.internal.requests.FilterRequest")) : class$org$junit$internal$requests$FilterRequest).getDeclaredField("fFilter");
        }
        catch (NoSuchFieldException e) {
            field = (class$org$junit$internal$requests$FilterRequest == null ? (class$org$junit$internal$requests$FilterRequest = JUnit4IdeaTestRunner.class$("org.junit.internal.requests.FilterRequest")) : class$org$junit$internal$requests$FilterRequest).getDeclaredField("filter");
        }
        field.setAccessible(true);
        Filter filter = (Filter)field.get(request);
        String filterDescription = filter.describe();
        if (filterDescription != null) {
            boolean isMethodFilter = filterDescription.startsWith("Method");
            if (isMethodFilter && JUnit4IdeaTestRunner.canCompress(description)) {
                return (Description)description.getChildren().get(0);
            }
            try {
                Description failedTestsDescription = Description.createSuiteDescription((String)filterDescription, null);
                if (filterDescription.startsWith("Tests") || filterDescription.startsWith("Ignored")) {
                    Iterator iterator = description.getChildren().iterator();
                    while (iterator.hasNext()) {
                        Description childDescription = (Description)iterator.next();
                        if (!filter.shouldRun(childDescription)) continue;
                        failedTestsDescription.addChild(childDescription);
                    }
                    description = failedTestsDescription;
                } else if (isMethodFilter && JUnit4IdeaTestRunner.canCompress(failedTestsDescription)) {
                    description = (Description)failedTestsDescription.getChildren().get(0);
                }
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
        }
        return description;
    }

    private static boolean canCompress(Description description) {
        return !description.isTest() && description.testCount() == 1;
    }

    private static Description getSuiteMethodDescription(Request request, Description description) throws NoSuchFieldException, IllegalAccessException {
        Field field;
        try {
            field = (class$org$junit$internal$requests$ClassRequest == null ? (class$org$junit$internal$requests$ClassRequest = JUnit4IdeaTestRunner.class$("org.junit.internal.requests.ClassRequest")) : class$org$junit$internal$requests$ClassRequest).getDeclaredField("fTestClass");
        }
        catch (NoSuchFieldException e) {
            field = (class$org$junit$internal$requests$ClassRequest == null ? (class$org$junit$internal$requests$ClassRequest = JUnit4IdeaTestRunner.class$("org.junit.internal.requests.ClassRequest")) : class$org$junit$internal$requests$ClassRequest).getDeclaredField("testClass");
        }
        field.setAccessible(true);
        Description methodDescription = Description.createSuiteDescription((Class)((Class)field.get(request)));
        Iterator iterator = description.getChildren().iterator();
        while (iterator.hasNext()) {
            methodDescription.addChild((Description)iterator.next());
        }
        description = methodDescription;
        return description;
    }

    public void setStreams(SegmentedOutputStream segmentedOut, SegmentedOutputStream segmentedErr, int lastIdx) {
        if (JUnitStarter.SM_RUNNER) {
            this.myTestsListener = new SMTestSender();
        } else {
            this.myRegistry = new JUnit4OutputObjectRegistry((PacketProcessor)segmentedOut, lastIdx);
            this.myTestsListener = new JUnit4TestResultsSender(this.myRegistry);
        }
    }

    public Object getTestToStart(String[] args, String name) {
        Request request = JUnit4TestRunnerUtil.buildRequest(args, name, false);
        if (request == null) {
            return null;
        }
        Runner testRunner = request.getRunner();
        Description description = null;
        try {
            description = testRunner.getDescription();
            if (request instanceof ClassRequest) {
                description = JUnit4IdeaTestRunner.getSuiteMethodDescription(request, description);
            } else if (request instanceof FilterRequest) {
                description = JUnit4IdeaTestRunner.getFilteredDescription(request, description);
            }
        }
        catch (Exception e) {
            System.err.println("Internal Error occured.");
            e.printStackTrace(System.err);
        }
        return description;
    }

    public List getChildTests(Object description) {
        return ((Description)description).getChildren();
    }

    public OutputObjectRegistry getRegistry() {
        return this.myRegistry;
    }

    public String getTestClassName(Object child) {
        return ((Description)child).getClassName();
    }

    public String getStartDescription(Object child) {
        Description description = (Description)child;
        String methodName = description.getMethodName();
        return methodName != null ? description.getClassName() + "," + methodName : description.getClassName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

