/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.intellij.plugins.xsltDebugger.rt.engine.Breakpoint;
import org.intellij.plugins.xsltDebugger.rt.engine.BreakpointManager;
import org.intellij.plugins.xsltDebugger.rt.engine.BreakpointManagerImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.DebuggerStoppedException;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.local.AbstractFrame;
import org.intellij.plugins.xsltDebugger.rt.engine.local.OutputEventQueueImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon.SaxonSupport;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.Saxon9Support;
import org.intellij.plugins.xsltDebugger.rt.engine.local.xalan.XalanSupport;

public class LocalDebugger
implements Debugger {
    private final Thread myThread;
    private final BreakpointManager myBreakpointManager;
    private final OutputEventQueueImpl myEventQueue;
    private volatile Condition myCurrentStopCondition;
    private final Object theLock = new Object();
    private volatile Debugger.State myState = Debugger.State.CREATED;
    private final LinkedList<Debugger.StyleFrame> myFrames = new LinkedList();
    private final LinkedList<Debugger.SourceFrame> mySourceFrames = new LinkedList();

    public LocalDebugger(final Transformer transformer, final Source source, final Result result) {
        this.prepareTransformer(transformer);
        this.myBreakpointManager = new BreakpointManagerImpl();
        this.myEventQueue = new OutputEventQueueImpl(this);
        this.myThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = LocalDebugger.this.theLock;
                    synchronized (object) {
                        LocalDebugger.this.myState = Debugger.State.RUNNING;
                        LocalDebugger.this.theLock.notifyAll();
                    }
                    transformer.transform(source, result);
                    LocalDebugger.this.stopped();
                }
                catch (DebuggerStoppedException e) {
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                    LocalDebugger.this.stopped();
                }
            }
        });
    }

    protected void prepareTransformer(Transformer transformer) {
        try {
            if (Saxon9Support.init(transformer, this)) {
                return;
            }
        }
        catch (NoClassDefFoundError e1) {
            // empty catch block
        }
        try {
            if (SaxonSupport.init(transformer, this)) {
                return;
            }
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            if (XalanSupport.init(transformer, this)) {
                return;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Unsupported Transformer: " + transformer.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendAndWait() throws DebuggerStoppedException {
        try {
            Object object = this.theLock;
            synchronized (object) {
                this.myCurrentStopCondition = null;
                this.myState = Debugger.State.SUSPENDED;
                this.theLock.notifyAll();
                do {
                    this.theLock.wait();
                } while (this.myState == Debugger.State.SUSPENDED);
                if (this.myState == Debugger.State.STOPPED) {
                    throw new DebuggerStoppedException();
                }
            }
        }
        catch (InterruptedException e) {
            throw new DebuggerStoppedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebuggerStoppedException {
        Object object = this.theLock;
        synchronized (object) {
            if (this.myState == Debugger.State.STOPPED) {
                throw new DebuggerStoppedException();
            }
            if (this.myState != Debugger.State.SUSPENDED) {
                throw new IllegalStateException();
            }
            this.myState = Debugger.State.RUNNING;
            this.theLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.theLock;
        synchronized (object) {
            if (this.myState == Debugger.State.STOPPED) {
                throw new DebuggerStoppedException();
            }
            if (this.myState != Debugger.State.RUNNING) {
                throw new IllegalStateException();
            }
            this.myCurrentStopCondition = Condition.TRUE;
        }
    }

    public void stopped() {
        assert (Thread.currentThread() == this.myThread);
        this.stop0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop0() {
        Object object = this.theLock;
        synchronized (object) {
            this.myState = Debugger.State.STOPPED;
            this.theLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Debugger.State getState() {
        Object object = this.theLock;
        synchronized (object) {
            return this.myState;
        }
    }

    public void stop(boolean force) {
        this.stop0();
        this.myThread.interrupt();
        if (!force) {
            return;
        }
        try {
            this.myThread.join(1000L);
            if (this.myThread.isAlive()) {
                this.myThread.stop();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Debugger.State waitForStateChange(Debugger.State state) {
        try {
            Object object = this.theLock;
            synchronized (object) {
                if (this.myState == Debugger.State.STOPPED) {
                    return Debugger.State.STOPPED;
                }
                while (this.myState == state) {
                    this.theLock.wait();
                }
                return this.myState;
            }
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForDebuggee() {
        try {
            Object object = this.theLock;
            synchronized (object) {
                while (this.myState == Debugger.State.RUNNING) {
                    this.theLock.wait();
                }
                return this.myState != Debugger.State.STOPPED;
            }
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        Object object = this.theLock;
        synchronized (object) {
            return this.myState == Debugger.State.STOPPED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        assert (this.myState == Debugger.State.CREATED) : "Already started";
        this.myThread.start();
        try {
            Object object = this.theLock;
            synchronized (object) {
                while (this.myState == Debugger.State.CREATED) {
                    this.theLock.wait();
                }
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public void enter(Debugger.StyleFrame frame) {
        assert (Thread.currentThread() == this.myThread);
        this.myFrames.addFirst(frame);
        String uri = frame.getURI();
        Debugger.StyleFrame previous = (Debugger.StyleFrame)frame.getPrevious();
        if (this.isStopped()) {
            throw new DebuggerStoppedException();
        }
        if (this.myCurrentStopCondition != null && this.myCurrentStopCondition.value()) {
            this.suspendAndWait();
        } else {
            int lineNumber = frame.getLineNumber();
            Breakpoint breakpoint = this.myBreakpointManager.getBreakpoint(uri, lineNumber);
            if (breakpoint != null && breakpoint.isEnabled() && (previous == null || previous.getLineNumber() != lineNumber)) {
                String condition = breakpoint.getCondition();
                try {
                    String traceMessage;
                    String logMessage;
                    if (this.evalCondition(condition) && (this.logBreakpoint(frame, logMessage = breakpoint.getLogMessage(), traceMessage = breakpoint.getTraceMessage()) || breakpoint.isSuspend())) {
                        this.suspendAndWait();
                    }
                }
                catch (Debugger.EvaluationException e) {
                    System.err.println("[" + lineNumber + "]: Failed to evaluate expression: " + condition + " -- " + e.getMessage());
                    breakpoint.setEnabled(false);
                }
            }
        }
    }

    private boolean evalCondition(String condition) throws Debugger.EvaluationException {
        return condition == null || condition.length() <= 0 || "true".equals(this.eval("boolean(" + condition + ")").getValue().toString());
    }

    private boolean logBreakpoint(Debugger.StyleFrame frame, String logMessage, String traceMessage) throws Debugger.EvaluationException {
        if (logMessage != null) {
            String uri = frame.getURI();
            String pos = uri.substring(uri.lastIndexOf(47) + 1) + ":" + frame.getLineNumber();
            System.out.println("[" + pos + "]: " + (logMessage.length() > 0 ? this.eval(logMessage).getValue().toString() : "<no message>"));
            if (traceMessage != null) {
                this.myEventQueue.trace(this.makeTraceMessage(traceMessage));
            }
            return false;
        }
        if (traceMessage != null) {
            this.myEventQueue.trace(this.makeTraceMessage(traceMessage));
            return false;
        }
        return true;
    }

    private String makeTraceMessage(String traceMessage) throws Debugger.EvaluationException {
        if (traceMessage.length() > 0) {
            return this.eval(traceMessage).getValue().toString();
        }
        return null;
    }

    public void leave() {
        assert (Thread.currentThread() == this.myThread);
        if (this.isStopped()) {
            throw new DebuggerStoppedException();
        }
        ((AbstractFrame)this.myFrames.removeFirst()).invalidate();
    }

    public void step() {
        final int targetSize = this.myFrames.size();
        this.myCurrentStopCondition = new Condition(){

            @Override
            public boolean value() {
                return LocalDebugger.this.myFrames.size() <= targetSize;
            }
        };
        this.resume();
    }

    public void stepInto() {
        this.myCurrentStopCondition = Condition.TRUE;
        this.resume();
    }

    public Value eval(String expr) throws Debugger.EvaluationException {
        Debugger.StyleFrame frame = this.getCurrentFrame();
        if (frame == null) {
            throw new Debugger.EvaluationException("No frame available");
        }
        return frame.eval(expr);
    }

    public Debugger.StyleFrame getCurrentFrame() {
        return this.myFrames.size() > 0 ? this.myFrames.getFirst() : null;
    }

    public Debugger.SourceFrame getSourceFrame() {
        return this.mySourceFrames.size() > 0 ? this.mySourceFrames.getFirst() : null;
    }

    public List<Debugger.Variable> getGlobalVariables() {
        List vars = this.getCurrentFrame().getVariables();
        Iterator it = vars.iterator();
        while (it.hasNext()) {
            Debugger.Variable var = (Debugger.Variable)it.next();
            if (var.isGlobal()) continue;
            it.remove();
        }
        return vars;
    }

    public BreakpointManager getBreakpointManager() {
        return this.myBreakpointManager;
    }

    public void pushSource(Debugger.SourceFrame sourceFrame) {
        this.mySourceFrames.addFirst(sourceFrame);
    }

    public void popSource() {
        ((AbstractFrame)this.mySourceFrames.removeFirst()).invalidate();
    }

    public OutputEventQueueImpl getEventQueue() {
        return this.myEventQueue;
    }

    public boolean ping() {
        return true;
    }

    static interface Condition {
        public static final Condition TRUE = new Condition(){

            @Override
            public boolean value() {
                return true;
            }
        };

        public boolean value();
    }
}

