/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadGridLayoutManager;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;

public class RadSwingGridLayoutManager
extends RadGridLayoutManager {
    private int myLastRow = 0;
    private int myLastColumn = 0;

    @Override
    public void createSnapshotLayout(SnapshotContext context, JComponent parent, RadContainer container, LayoutManager layout) {
        GridLayout gridLayout = (GridLayout)layout;
        int ncomponents = parent.getComponentCount();
        int nrows = gridLayout.getRows();
        int ncols = gridLayout.getColumns();
        if (nrows > 0) {
            ncols = (ncomponents + nrows - 1) / nrows;
        } else {
            nrows = (ncomponents + ncols - 1) / ncols;
        }
        container.setLayout((LayoutManager)new GridLayoutManager(nrows, ncols, new Insets(0, 0, 0, 0), gridLayout.getHgap(), gridLayout.getVgap(), true, true));
    }

    @Override
    public void addSnapshotComponent(JComponent parent, JComponent child, RadContainer container, RadComponent component) {
        GridLayoutManager grid = (GridLayoutManager)container.getLayout();
        component.getConstraints().setRow(this.myLastRow);
        component.getConstraints().setColumn(this.myLastColumn);
        component.getConstraints().setFill(3);
        if (this.myLastColumn == grid.getColumnCount() - 1) {
            ++this.myLastRow;
            this.myLastColumn = 0;
        } else {
            ++this.myLastColumn;
        }
        container.addComponent(component);
    }
}

