/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.pom.java.LanguageLevel;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public enum JavaSdkVersion {
    JDK_1_0(LanguageLevel.JDK_1_3, "1.0"),
    JDK_1_1(LanguageLevel.JDK_1_3, "1.1"),
    JDK_1_2(LanguageLevel.JDK_1_3, "1.2"),
    JDK_1_3(LanguageLevel.JDK_1_3, "1.3"),
    JDK_1_4(LanguageLevel.JDK_1_4, "1.4"),
    JDK_1_5(LanguageLevel.JDK_1_5, "1.5"),
    JDK_1_6(LanguageLevel.JDK_1_6, "1.6"),
    JDK_1_7(LanguageLevel.JDK_1_7, "1.7"),
    JDK_1_8(LanguageLevel.JDK_1_8, "1.8"),
    JDK_1_9(LanguageLevel.JDK_1_9, "1.9");

    private static final JavaSdkVersion MAX_JDK;
    private final LanguageLevel myMaxLanguageLevel;
    private final String myDescription;

    private JavaSdkVersion(LanguageLevel maxLanguageLevel, String description) {
        if (maxLanguageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maxLanguageLevel", "com/intellij/openapi/projectRoots/JavaSdkVersion", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/openapi/projectRoots/JavaSdkVersion", "<init>"));
        }
        this.myMaxLanguageLevel = maxLanguageLevel;
        this.myDescription = description;
    }

    @NotNull
    public LanguageLevel getMaxLanguageLevel() {
        LanguageLevel languageLevel = this.myMaxLanguageLevel;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/JavaSdkVersion", "getMaxLanguageLevel"));
        }
        return languageLevel;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/JavaSdkVersion", "getDescription"));
        }
        return string;
    }

    public boolean isAtLeast(@NotNull JavaSdkVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/projectRoots/JavaSdkVersion", "isAtLeast"));
        }
        return this.compareTo(version) >= 0;
    }

    public String toString() {
        return super.toString() + ", description: " + this.myDescription;
    }

    @NotNull
    public static JavaSdkVersion byDescription(@NotNull String description) throws IllegalArgumentException {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/openapi/projectRoots/JavaSdkVersion", "byDescription"));
        }
        for (JavaSdkVersion version : JavaSdkVersion.values()) {
            if (!version.getDescription().equals(description)) continue;
            JavaSdkVersion javaSdkVersion = version;
            if (javaSdkVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/JavaSdkVersion", "byDescription"));
            }
            return javaSdkVersion;
        }
        throw new IllegalArgumentException(String.format("Can't map Java SDK by description (%s). Available values: %s", description, Arrays.toString((Object[])JavaSdkVersion.values())));
    }

    @NotNull
    public static JavaSdkVersion fromLanguageLevel(@NotNull LanguageLevel languageLevel) throws IllegalArgumentException {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/openapi/projectRoots/JavaSdkVersion", "fromLanguageLevel"));
        }
        if (languageLevel == LanguageLevel.JDK_X) {
            JavaSdkVersion javaSdkVersion = MAX_JDK;
            if (javaSdkVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/JavaSdkVersion", "fromLanguageLevel"));
            }
            return javaSdkVersion;
        }
        JavaSdkVersion[] values = JavaSdkVersion.values();
        for (int i = values.length - 1; i >= 0; --i) {
            JavaSdkVersion version = values[i];
            if (!version.getMaxLanguageLevel().isAtLeast(languageLevel)) continue;
            JavaSdkVersion javaSdkVersion = version;
            if (javaSdkVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/JavaSdkVersion", "fromLanguageLevel"));
            }
            return javaSdkVersion;
        }
        throw new IllegalArgumentException("Can't map Java SDK by language level " + (Object)((Object)languageLevel) + ". Available values: " + Arrays.toString((Object[])JavaSdkVersion.values()));
    }

    static {
        MAX_JDK = JDK_1_9;
    }
}

