/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.Patches;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SystemProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetUtils {
    private static final Logger LOG = Logger.getInstance(NetUtils.class);

    private NetUtils() {
    }

    public static boolean canConnectToSocket(String host, int port) {
        return NetUtils.canConnectToSocket(host, port, false);
    }

    public static boolean canConnectToSocketOpenedByJavaProcess(String host, int port) {
        return NetUtils.canConnectToSocket(host, port, Patches.SUN_BUG_ID_7179799);
    }

    private static boolean canConnectToSocket(String host, int port, boolean alwaysTryToConnectDirectly) {
        if (NetUtils.isLocalhost(host)) {
            if (!NetUtils.canBindToLocalSocket(host, port)) {
                return true;
            }
            return alwaysTryToConnectDirectly && NetUtils.canConnectToRemoteSocket(host, port);
        }
        return NetUtils.canConnectToRemoteSocket(host, port);
    }

    public static InetAddress getLoopbackAddress() {
        try {
            return InetAddress.getByName(null);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isLocalhost(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/net/NetUtils", "isLocalhost"));
        }
        return host.equalsIgnoreCase("localhost") || host.equals("127.0.0.1") || host.equals("::1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canBindToLocalSocket(String host, int port) {
        try {
            ServerSocket socket = new ServerSocket();
            try {
                socket.bind(new InetSocketAddress(host, port));
            }
            finally {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            return true;
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    public static boolean canConnectToRemoteSocket(String host, int port) {
        try {
            Socket socket = new Socket(host, port);
            socket.close();
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findAvailableSocketPort() throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        try {
            int port = serverSocket.getLocalPort();
            ServerSocket serverSocket2 = serverSocket;
            synchronized (serverSocket2) {
                try {
                    serverSocket.wait(1L);
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
            }
            int n = port;
            return n;
        }
        finally {
            serverSocket.close();
        }
    }

    public static int tryToFindAvailableSocketPort(int defaultPort) {
        try {
            return NetUtils.findAvailableSocketPort();
        }
        catch (IOException ignored) {
            return defaultPort;
        }
    }

    public static int tryToFindAvailableSocketPort() {
        return NetUtils.tryToFindAvailableSocketPort(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] findAvailableSocketPorts(int capacity) throws IOException {
        int[] ports = new int[capacity];
        ServerSocket[] sockets = new ServerSocket[capacity];
        for (int i = 0; i < capacity; ++i) {
            ServerSocket serverSocket;
            sockets[i] = serverSocket = new ServerSocket(0);
            ports[i] = serverSocket.getLocalPort();
        }
        ServerSocket[] i = sockets;
        synchronized (sockets) {
            try {
                sockets.wait(1L);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            for (ServerSocket socket : sockets) {
                socket.close();
            }
            return ports;
        }
    }

    public static String getLocalHostString() {
        String localHostString = "localhost";
        try {
            InetAddress localHost = InetAddress.getByName(localHostString);
            if (localHost.getAddress().length != 4 && SystemInfo.isWindows || localHost.getAddress().length == 4 && SystemInfo.isMac) {
                localHostString = "127.0.0.1";
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localHostString;
    }

    public static int copyStreamContent(@Nullable ProgressIndicator indicator, @NotNull InputStream inputStream, @NotNull OutputStream outputStream, int expectedContentSize) throws IOException, ProcessCanceledException {
        int count;
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/net/NetUtils", "copyStreamContent"));
        }
        if (outputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputStream", "com/intellij/util/net/NetUtils", "copyStreamContent"));
        }
        if (indicator != null) {
            indicator.checkCanceled();
            if (expectedContentSize < 0) {
                indicator.setIndeterminate(true);
            }
        }
        byte[] buffer = new byte[8192];
        int total = 0;
        while ((count = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, count);
            total += count;
            if (indicator == null) continue;
            indicator.checkCanceled();
            if (expectedContentSize <= 0) continue;
            indicator.setFraction((double)total / (double)expectedContentSize);
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        return total;
    }

    public static boolean isSniEnabled() {
        return SystemInfo.isJavaVersionAtLeast((String)"1.7") && SystemProperties.getBooleanProperty((String)"jsse.enableSNIExtension", (boolean)true);
    }
}

