/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations;

import com.android.annotations.Nullable;
import com.android.tools.idea.editors.allocations.AllocationsTableModel;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ui.table.JBTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class AllocationsRowListener
implements ListSelectionListener {
    private final JBTable myAllocationsTable;
    private final ConsoleView myConsoleView;

    public AllocationsRowListener(@NotNull JBTable allocationsTable, @Nullable ConsoleView consoleView) {
        if (allocationsTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allocationsTable", "com/android/tools/idea/editors/allocations/AllocationsRowListener", "<init>"));
        }
        this.myAllocationsTable = allocationsTable;
        this.myConsoleView = consoleView;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (this.myConsoleView == null) {
            return;
        }
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (this.myAllocationsTable.getSelectedRowCount() != 1) {
            return;
        }
        int viewRow = this.myAllocationsTable.getSelectedRow();
        int row = this.myAllocationsTable.convertRowIndexToModel(viewRow);
        this.myConsoleView.clear();
        this.myConsoleView.print(this.getStackTrace(row), ConsoleViewContentType.NORMAL_OUTPUT);
        this.myConsoleView.scrollTo(0);
    }

    @NotNull
    private String getStackTrace(int row) {
        StringBuilder stackTrace = new StringBuilder();
        StackTraceElement[] stackTraceElements = ((AllocationsTableModel)this.myAllocationsTable.getModel()).getAllocation(row).getStackTrace();
        if (stackTraceElements != null) {
            for (StackTraceElement element : stackTraceElements) {
                if (element == null) continue;
                stackTrace.append("at ");
                stackTrace.append(element.toString());
                stackTrace.append("\n");
            }
        }
        String string = stackTrace.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsRowListener", "getStackTrace"));
        }
        return string;
    }
}

