/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.DateFormatUtil;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CommandUtil {
    public static void put(@NotNull List<String> parameters, boolean condition, @NotNull String value) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (condition) {
            parameters.add(value);
        }
    }

    public static void put(@NotNull List<String> parameters, @NotNull File path) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        CommandUtil.put(parameters, path.getAbsolutePath(), SVNRevision.UNDEFINED);
    }

    public static void put(@NotNull List<String> parameters, @NotNull File path, boolean usePegRevision) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (usePegRevision) {
            CommandUtil.put(parameters, path);
        } else {
            parameters.add(path.getAbsolutePath());
        }
    }

    public static void put(@NotNull List<String> parameters, @NotNull File path, @Nullable SVNRevision pegRevision) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        CommandUtil.put(parameters, path.getAbsolutePath(), pegRevision);
    }

    public static void put(@NotNull List<String> parameters, @NotNull String path, @Nullable SVNRevision pegRevision) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        parameters.add(CommandUtil.format(path, pegRevision));
    }

    @NotNull
    public static String format(@NotNull String path, @Nullable SVNRevision pegRevision) {
        boolean hasPegRevision;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/commandLine/CommandUtil", "format"));
        }
        StringBuilder builder = new StringBuilder(path);
        boolean hasAtSymbol = path.contains("@");
        boolean bl = hasPegRevision = pegRevision != null && !SVNRevision.UNDEFINED.equals((Object)pegRevision) && !SVNRevision.WORKING.equals((Object)pegRevision) && pegRevision.isValid();
        if (hasPegRevision || hasAtSymbol) {
            builder.append("@");
        }
        if (hasPegRevision) {
            builder.append(CommandUtil.format(pegRevision));
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandUtil", "format"));
        }
        return string;
    }

    public static void put(@NotNull List<String> parameters, @NotNull SvnTarget target) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        CommandUtil.put(parameters, target.getPathOrUrlString(), target.getPegRevision());
    }

    public static void put(@NotNull List<String> parameters, @NotNull SvnTarget target, boolean usePegRevision) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (usePegRevision) {
            CommandUtil.put(parameters, target);
        } else {
            parameters.add(target.getPathOrUrlString());
        }
    }

    public static void put(@NotNull List<String> parameters, @Nullable Depth depth) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        CommandUtil.put(parameters, depth, false);
    }

    public static void put(@NotNull List<String> parameters, @Nullable Depth depth, boolean sticky) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (depth != null && !Depth.UNKNOWN.equals((Object)depth)) {
            parameters.add("--depth");
            parameters.add(depth.getName());
            if (sticky) {
                parameters.add("--set-depth");
                parameters.add(depth.getName());
            }
        }
    }

    public static void put(@NotNull List<String> parameters, @Nullable SVNRevision revision) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (revision != null && !SVNRevision.UNDEFINED.equals((Object)revision) && !SVNRevision.WORKING.equals((Object)revision) && revision.isValid()) {
            parameters.add("--revision");
            parameters.add(CommandUtil.format(revision));
        }
    }

    public static void put(@NotNull List<String> parameters, @NotNull SVNRevision startRevision, @NotNull SVNRevision endRevision) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (startRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startRevision", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (endRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endRevision", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        parameters.add("--revision");
        parameters.add(CommandUtil.format(startRevision) + ":" + CommandUtil.format(endRevision));
    }

    @NotNull
    public static String format(@NotNull SVNRevision revision) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/commandLine/CommandUtil", "format"));
        }
        String string = revision.getDate() != null ? "{" + DateFormatUtil.ISO8601_DATE_FORMAT.format(revision.getDate()) + "}" : revision.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandUtil", "format"));
        }
        return string;
    }

    public static void put(@NotNull List<String> parameters, @Nullable DiffOptions diffOptions) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (diffOptions != null) {
            String value;
            StringBuilder builder = new StringBuilder();
            if (diffOptions.isIgnoreAllWhitespace()) {
                builder.append(" --ignore-space-change");
            }
            if (diffOptions.isIgnoreAmountOfWhitespace()) {
                builder.append(" --ignore-all-space");
            }
            if (diffOptions.isIgnoreEOLStyle()) {
                builder.append(" --ignore-eol-style");
            }
            if (!StringUtil.isEmpty((String)(value = builder.toString().trim()))) {
                parameters.add("--extensions");
                parameters.add(value);
            }
        }
    }

    public static void putChangeLists(@NotNull List<String> parameters, @Nullable Iterable<String> changeLists) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/CommandUtil", "putChangeLists"));
        }
        if (changeLists != null) {
            for (String changeList : changeLists) {
                parameters.add("--cl");
                parameters.add(changeList);
            }
        }
    }

    public static String escape(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/commandLine/CommandUtil", "escape"));
        }
        return path.contains("@") ? path + "@" : path;
    }

    public static <T> T parse(@NotNull String data, @NotNull Class<T> type) throws JAXBException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/commandLine/CommandUtil", "parse"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/svn/commandLine/CommandUtil", "parse"));
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (T)unmarshaller.unmarshal((Reader)new StringReader(data.trim()));
    }

    @NotNull
    public static File getHomeDirectory() {
        File file = new File(PathManager.getHomePath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandUtil", "getHomeDirectory"));
        }
        return file;
    }

    public static char getStatusChar(@Nullable String type) {
        return !StringUtil.isEmpty((String)type) ? type.charAt(0) : (char)' ';
    }

    @NotNull
    public static StatusType getStatusType(@Nullable String type) {
        StatusType statusType = CommandUtil.getStatusType(CommandUtil.getStatusChar(type));
        if (statusType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandUtil", "getStatusType"));
        }
        return statusType;
    }

    @NotNull
    public static StatusType getStatusType(char first) {
        StatusType contentsStatus = 'A' == first ? StatusType.STATUS_ADDED : ('D' == first ? StatusType.STATUS_DELETED : ('U' == first ? StatusType.CHANGED : ('C' == first ? StatusType.CONFLICTED : ('G' == first ? StatusType.MERGED : ('R' == first ? StatusType.STATUS_REPLACED : ('E' == first ? StatusType.STATUS_OBSTRUCTED : StatusType.STATUS_NORMAL))))));
        StatusType statusType = contentsStatus;
        if (statusType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandUtil", "getStatusType"));
        }
        return statusType;
    }

    public static File correctUpToExistingParent(File base) {
        while (base != null) {
            if (base.exists() && base.isDirectory()) {
                return base;
            }
            base = base.getParentFile();
        }
        return null;
    }
}

