/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import java.io.File;
import java.util.Arrays;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitRebaseEditorMain {
    @NonNls
    @NotNull
    public static final String IDEA_REBASE_HANDER_NO = "IDEA_REBASE_HANDER_NO";
    public static final int ERROR_EXIT_CODE = 2;
    @NonNls
    static final String HANDLER_NAME = "Git4ideaRebaseEditorHandler";
    private static final String CYGDRIVE_PREFIX = "/cygdrive/";

    private GitRebaseEditorMain() {
    }

    public static void main(String[] args) {
        int handler;
        int port;
        if (args.length != 2) {
            System.err.println("Invalid amount of arguments: " + Arrays.asList(args));
            System.exit(2);
        }
        try {
            port = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            System.err.println("Invalid port number: " + args[0]);
            System.exit(2);
            return;
        }
        String handlerValue = System.getenv(IDEA_REBASE_HANDER_NO);
        if (handlerValue == null) {
            System.err.println("Handler no is not specified");
            System.exit(2);
        }
        try {
            handler = Integer.parseInt(handlerValue);
        }
        catch (NumberFormatException ex) {
            System.err.println("Invalid handler number: " + handlerValue);
            System.exit(2);
            return;
        }
        String file = args[1];
        try {
            XmlRpcClientLite client = new XmlRpcClientLite("127.0.0.1", port);
            Vector<Object> params = new Vector<Object>();
            params.add(handler);
            if (System.getProperty("os.name").toLowerCase().startsWith("windows") && file.startsWith(CYGDRIVE_PREFIX)) {
                int p = CYGDRIVE_PREFIX.length();
                file = file.substring(p, p + 1) + ":" + file.substring(p + 1);
            }
            params.add(new File(file).getAbsolutePath());
            Integer exitCode = (Integer)client.execute("Git4ideaRebaseEditorHandler.editCommits", params);
            if (exitCode == null) {
                exitCode = 2;
            }
            System.exit(exitCode);
        }
        catch (Exception e) {
            System.err.println("Unable to contact IDEA: " + e);
            e.printStackTrace();
            System.exit(2);
        }
    }
}

