/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemProperties {
    private static final Set<String> STANDARD_PROPERTIES = ImmutableSet.of((Object)"java.version", (Object)"java.vendor", (Object)"java.vendor.url", (Object)"java.home", (Object)"java.vm.specification.version", (Object)"java.vm.specification.vendor", (Object[])new String[]{"java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir"});
    private static final Set<String> IMPORTANT_NON_STANDARD_PROPERTIES = ImmutableSet.of((Object)"java.runtime.version");

    public static Map<String, String> asMap() {
        return System.getProperties();
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getJavaIoTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static File getCurrentDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static Set<String> getStandardProperties() {
        return STANDARD_PROPERTIES;
    }

    public static Set<String> getNonStandardImportantProperties() {
        return IMPORTANT_NON_STANDARD_PROPERTIES;
    }
}

