/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBViewport;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBScrollPane
extends JScrollPane {
    private int myViewportBorderWidth = -1;
    private boolean myHasOverlayScrollbars;
    private int myOverriddenVPolicy = -1;
    private int myOverriddenHPolicy = -1;

    public JBScrollPane(int viewportWidth) {
        this.init(false);
        this.myViewportBorderWidth = viewportWidth;
        this.updateViewportBorder();
    }

    public JBScrollPane() {
        this.init();
    }

    public JBScrollPane(Component view) {
        super(view);
        this.init();
    }

    public JBScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.init();
    }

    public JBScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.init();
    }

    public static JScrollPane findScrollPane(Component c) {
        Container vp;
        if (c == null) {
            return null;
        }
        if (!(c instanceof JViewport) && (vp = c.getParent()) instanceof JViewport) {
            c = vp;
        }
        if (!((c = c.getParent()) instanceof JScrollPane)) {
            return null;
        }
        return (JScrollPane)c;
    }

    private void init() {
        this.init(true);
    }

    private void init(boolean setupCorners) {
        this.setLayout(new ScrollPaneLayout());
        if (setupCorners) {
            this.setupCorners();
        }
    }

    protected void setupCorners() {
        this.setBorder(IdeBorderFactory.createBorder());
        this.setCorner("UPPER_RIGHT_CORNER", new Corner("UPPER_RIGHT_CORNER"));
        this.setCorner("UPPER_LEFT_CORNER", new Corner("UPPER_LEFT_CORNER"));
        this.setCorner("LOWER_RIGHT_CORNER", new Corner("LOWER_RIGHT_CORNER"));
        this.setCorner("LOWER_LEFT_CORNER", new Corner("LOWER_LEFT_CORNER"));
    }

    @Override
    public void setUI(ScrollPaneUI ui) {
        super.setUI(ui);
        this.updateViewportBorder();
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return !this.myHasOverlayScrollbars;
    }

    private void updateViewportBorder() {
        this.setViewportBorder(new ViewportBorder(this.myViewportBorderWidth >= 0 ? this.myViewportBorderWidth : 1));
    }

    public static ViewportBorder createIndentBorder() {
        return new ViewportBorder(2);
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        return new MyScrollBar(1);
    }

    @Override
    public JScrollBar createHorizontalScrollBar() {
        return new MyScrollBar(0);
    }

    @Override
    protected JViewport createViewport() {
        return new JBViewport();
    }

    @Override
    public int getHorizontalScrollBarPolicy() {
        return this.myOverriddenHPolicy != -1 ? this.myOverriddenHPolicy : super.getHorizontalScrollBarPolicy();
    }

    @Override
    public int getVerticalScrollBarPolicy() {
        return this.myOverriddenVPolicy != -1 ? this.myOverriddenVPolicy : super.getVerticalScrollBarPolicy();
    }

    @Override
    public void layout() {
        LayoutManager layout = this.getLayout();
        ScrollPaneLayout scrollLayout = layout instanceof ScrollPaneLayout ? (ScrollPaneLayout)layout : null;
        int oldHPolicy = -1;
        int oldVPolicy = -1;
        if (scrollLayout != null) {
            if (this.isOverlaidScrollbar(this.getHorizontalScrollBar()) && (oldHPolicy = scrollLayout.getHorizontalScrollBarPolicy()) == 32) {
                this.myOverriddenHPolicy = 30;
                scrollLayout.setHorizontalScrollBarPolicy(30);
            }
            if (this.isOverlaidScrollbar(this.getVerticalScrollBar()) && (oldVPolicy = scrollLayout.getVerticalScrollBarPolicy()) == 22) {
                this.myOverriddenVPolicy = 20;
                scrollLayout.setVerticalScrollBarPolicy(20);
            }
        }
        super.layout();
        if (scrollLayout != null) {
            this.myHasOverlayScrollbars = this.relayoutScrollbars(this, scrollLayout, this.myHasOverlayScrollbars);
            if (oldHPolicy != -1) {
                scrollLayout.setHorizontalScrollBarPolicy(oldHPolicy);
            }
            if (oldVPolicy != -1) {
                scrollLayout.setVerticalScrollBarPolicy(oldVPolicy);
            }
            this.myOverriddenHPolicy = -1;
            this.myOverriddenVPolicy = -1;
        } else {
            this.myHasOverlayScrollbars = false;
        }
    }

    private boolean relayoutScrollbars(@NotNull JComponent container, @NotNull ScrollPaneLayout layout, boolean forceRelayout) {
        boolean hasOverlayScrollbars;
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/ui/components/JBScrollPane", "relayoutScrollbars"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/ui/components/JBScrollPane", "relayoutScrollbars"));
        }
        JViewport viewport = layout.getViewport();
        if (viewport == null) {
            return false;
        }
        JScrollBar vsb = layout.getVerticalScrollBar();
        JScrollBar hsb = layout.getHorizontalScrollBar();
        JViewport colHead = layout.getColumnHeader();
        JViewport rowHead = layout.getRowHeader();
        Rectangle viewportBounds = viewport.getBounds();
        boolean extendViewportUnderVScrollbar = vsb != null && this.shouldExtendViewportUnderScrollbar(vsb);
        boolean extendViewportUnderHScrollbar = hsb != null && this.shouldExtendViewportUnderScrollbar(hsb);
        boolean bl = hasOverlayScrollbars = extendViewportUnderVScrollbar || extendViewportUnderHScrollbar;
        if (!hasOverlayScrollbars && !forceRelayout) {
            return false;
        }
        container.setComponentZOrder(viewport, container.getComponentCount() - 1);
        if (vsb != null) {
            container.setComponentZOrder(vsb, 0);
        }
        if (hsb != null) {
            container.setComponentZOrder(hsb, 0);
        }
        if (extendViewportUnderVScrollbar) {
            int x2 = Math.max(vsb.getX() + vsb.getWidth(), viewportBounds.x + viewportBounds.width);
            viewportBounds.x = Math.min(viewportBounds.x, vsb.getX());
            viewportBounds.width = x2 - viewportBounds.x;
        }
        if (extendViewportUnderHScrollbar) {
            int y2 = Math.max(hsb.getY() + hsb.getHeight(), viewportBounds.y + viewportBounds.height);
            viewportBounds.y = Math.min(viewportBounds.y, hsb.getY());
            viewportBounds.height = y2 - viewportBounds.y;
        }
        if (extendViewportUnderVScrollbar) {
            if (hsb != null) {
                Rectangle scrollbarBounds = hsb.getBounds();
                scrollbarBounds.width = viewportBounds.x + viewportBounds.width - scrollbarBounds.x;
                hsb.setBounds(scrollbarBounds);
            }
            if (colHead != null) {
                Rectangle headerBounds = colHead.getBounds();
                headerBounds.width = viewportBounds.width;
                colHead.setBounds(headerBounds);
            }
            JBScrollPane.hideFromView(layout.getCorner("UPPER_RIGHT_CORNER"));
            JBScrollPane.hideFromView(layout.getCorner("LOWER_RIGHT_CORNER"));
        }
        if (extendViewportUnderHScrollbar) {
            if (vsb != null) {
                Rectangle scrollbarBounds = vsb.getBounds();
                scrollbarBounds.height = viewportBounds.y + viewportBounds.height - scrollbarBounds.y;
                vsb.setBounds(scrollbarBounds);
            }
            if (rowHead != null) {
                Rectangle headerBounds = rowHead.getBounds();
                headerBounds.height = viewportBounds.height;
                rowHead.setBounds(headerBounds);
            }
            JBScrollPane.hideFromView(layout.getCorner("LOWER_LEFT_CORNER"));
            JBScrollPane.hideFromView(layout.getCorner("LOWER_RIGHT_CORNER"));
        }
        viewport.setBounds(viewportBounds);
        return hasOverlayScrollbars;
    }

    private boolean shouldExtendViewportUnderScrollbar(@Nullable JScrollBar scrollbar) {
        if (scrollbar == null || !scrollbar.isVisible()) {
            return false;
        }
        return this.isOverlaidScrollbar(scrollbar);
    }

    protected boolean isOverlaidScrollbar(@Nullable JScrollBar scrollbar) {
        if (!ButtonlessScrollBarUI.isMacOverlayScrollbarSupported()) {
            return false;
        }
        ScrollBarUI vsbUI = scrollbar == null ? null : scrollbar.getUI();
        return vsbUI instanceof ButtonlessScrollBarUI && !((ButtonlessScrollBarUI)vsbUI).alwaysShowTrack();
    }

    private static void hideFromView(Component component) {
        if (component == null) {
            return;
        }
        component.setBounds(-10, -10, 1, 1);
    }

    public static boolean canBePreprocessed(MouseEvent e, JScrollBar bar) {
        ScrollBarUI ui;
        if ((e.getID() == 503 || e.getID() == 501) && (ui = bar.getUI()) instanceof BasicScrollBarUI) {
            BasicScrollBarUI bui = (BasicScrollBarUI)ui;
            try {
                Rectangle rect = (Rectangle)ReflectionUtil.getDeclaredMethod(BasicScrollBarUI.class, (String)"getThumbBounds", (Class[])ArrayUtil.EMPTY_CLASS_ARRAY).invoke((Object)bui, new Object[0]);
                Point point = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), bar);
                return !rect.contains(point);
            }
            catch (Exception e1) {
                return true;
            }
        }
        return true;
    }

    private static class ViewportBorder
    extends LineBorder {
        public ViewportBorder(int thickness) {
            super(null, thickness);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.updateColor(c);
            super.paintBorder(c, g, x, y, width, height);
        }

        private void updateColor(Component c) {
            if (!(c instanceof JScrollPane)) {
                return;
            }
            JViewport vp = ((JScrollPane)c).getViewport();
            if (vp == null) {
                return;
            }
            Component view = vp.getView();
            if (view == null) {
                return;
            }
            this.lineColor = view.getBackground();
        }
    }

    private static class Corner
    extends JPanel {
        private final String myPos;

        public Corner(String pos) {
            this.myPos = pos;
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor((Color)ButtonlessScrollBarUI.getTrackBackgroundDefault());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor((Color)ButtonlessScrollBarUI.getTrackBorderColorDefault());
            int x2 = this.getWidth() - 1;
            int y2 = this.getHeight() - 1;
            if (this.myPos == "UPPER_LEFT_CORNER" || this.myPos == "UPPER_RIGHT_CORNER") {
                g.drawLine(0, y2, x2, y2);
            }
            if (this.myPos == "LOWER_LEFT_CORNER" || this.myPos == "LOWER_RIGHT_CORNER") {
                g.drawLine(0, 0, x2, 0);
            }
            if (this.myPos == "UPPER_LEFT_CORNER" || this.myPos == "LOWER_LEFT_CORNER") {
                g.drawLine(x2, 0, x2, y2);
            }
            if (this.myPos == "UPPER_RIGHT_CORNER" || this.myPos == "LOWER_RIGHT_CORNER") {
                g.drawLine(0, 0, 0, y2);
            }
        }
    }

    private class MyScrollBar
    extends JScrollPane.ScrollBar
    implements IdeGlassPane.TopComponent {
        public MyScrollBar(int orientation) {
            super(JBScrollPane.this, orientation);
        }

        @Override
        public void updateUI() {
            this.setUI(ButtonlessScrollBarUI.createNormal());
        }

        @Override
        public boolean canBePreprocessed(MouseEvent e) {
            return JBScrollPane.canBePreprocessed(e, this);
        }
    }
}

