/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.incremental.BuildListener;
import org.jetbrains.jps.incremental.CompileContextImpl;
import org.jetbrains.jps.incremental.fs.BuildFSState;

class ChainedTargetsBuildListener
implements BuildListener {
    private final CompileContextImpl myContext;

    public ChainedTargetsBuildListener(CompileContextImpl context) {
        this.myContext = context;
    }

    @Override
    public void filesGenerated(Collection<Pair<String, String>> paths) {
        BuildFSState fsState = this.myContext.getProjectDescriptor().fsState;
        BuildRootIndex rootsIndex = this.myContext.getProjectDescriptor().getBuildRootIndex();
        for (Pair<String, String> pair : paths) {
            String relativePath = (String)pair.getSecond();
            File file = relativePath.equals(".") ? new File((String)pair.getFirst()) : new File((String)pair.getFirst(), relativePath);
            Collection descriptors = rootsIndex.findAllParentDescriptors(file, null, this.myContext);
            for (BuildRootDescriptor descriptor : descriptors) {
                try {
                    fsState.markDirty(this.myContext, file, descriptor, this.myContext.getProjectDescriptor().timestamps.getStorage());
                }
                catch (IOException ignored) {}
            }
        }
    }

    @Override
    public void filesDeleted(Collection<String> paths) {
        BuildFSState state = this.myContext.getProjectDescriptor().fsState;
        BuildRootIndex rootsIndex = this.myContext.getProjectDescriptor().getBuildRootIndex();
        for (String path : paths) {
            File file = new File(FileUtil.toSystemDependentName((String)path));
            Collection descriptors = rootsIndex.findAllParentDescriptors(file, null, this.myContext);
            for (BuildRootDescriptor descriptor : descriptors) {
                state.registerDeleted(descriptor.getTarget(), file);
            }
        }
    }
}

