/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import javax.swing.JComponent;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.psi.XPath2SequenceType;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.validation.ExpectedTypeUtil;
import org.intellij.lang.xpath.validation.inspections.XPathInspection;
import org.intellij.lang.xpath.validation.inspections.quickfix.XPathQuickFixFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantTypeConversion
extends XPathInspection {
    @NonNls
    private static final String SHORT_NAME = "RedundantTypeConversion";
    public boolean CHECK_ANY = false;

    @NotNull
    public String getDisplayName() {
        if ("Redundant Type Conversion" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/validation/inspections/RedundantTypeConversion", "getDisplayName"));
        }
        return "Redundant Type Conversion";
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/validation/inspections/RedundantTypeConversion", "getShortName"));
        }
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected XPathInspection.Visitor createVisitor(InspectionManager manager, boolean isOnTheFly) {
        return new MyElementVisitor(manager, isOnTheFly);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return null;
    }

    @Override
    protected boolean acceptsLanguage(Language language) {
        return language == XPathFileType.XPATH.getLanguage() || language == XPathFileType.XPATH2.getLanguage();
    }

    final class MyElementVisitor
    extends XPathInspection.Visitor {
        MyElementVisitor(InspectionManager manager, boolean isOnTheFly) {
            super(manager, isOnTheFly);
        }

        @Override
        protected void checkExpression(@NotNull XPathExpression expr) {
            if (expr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/intellij/lang/xpath/validation/inspections/RedundantTypeConversion$MyElementVisitor", "checkExpression"));
            }
            if (ExpectedTypeUtil.isExplicitConversion(expr)) {
                XPathType expectedType;
                XPathExpression expression = ExpectedTypeUtil.unparenthesize(expr);
                assert (expression != null);
                XPathType convertedType = ((XPathFunctionCall)expression).getArgumentList()[0].getType();
                if (this.isSameType(expression, convertedType)) {
                    XPathQuickFixFactory fixFactory = ContextProvider.getContextProvider(expression).getQuickFixFactory();
                    XPathQuickFixFactory.Fix<XPathExpression>[] fixes = fixFactory.createRedundantTypeConversionFixes(expression);
                    this.addProblem(this.myManager.createProblemDescriptor((PsiElement)expression, "Redundant conversion to type '" + convertedType.getName() + "'", this.myOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                } else if (RedundantTypeConversion.this.CHECK_ANY && (expectedType = ExpectedTypeUtil.getExpectedType(expression)) == XPathType.ANY) {
                    XPathQuickFixFactory fixFactory = ContextProvider.getContextProvider(expression).getQuickFixFactory();
                    XPathQuickFixFactory.Fix<XPathExpression>[] fixes = fixFactory.createRedundantTypeConversionFixes(expression);
                    this.addProblem(this.myManager.createProblemDescriptor((PsiElement)expression, "Redundant conversion to type '" + expectedType.getName() + "'", this.myOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
            }
        }

        private boolean isSameType(XPathExpression expression, XPathType convertedType) {
            XPathType type = ExpectedTypeUtil.mapType(expression, expression.getType());
            while (type instanceof XPath2SequenceType) {
                type = ((XPath2SequenceType)type).getType();
            }
            while (convertedType instanceof XPath2SequenceType) {
                convertedType = ((XPath2SequenceType)convertedType).getType();
            }
            return ExpectedTypeUtil.mapType(expression, convertedType) == type;
        }
    }
}

