/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSettingsListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesModel {
    private final List<CodeStyleScheme> mySchemes = new ArrayList<CodeStyleScheme>();
    private CodeStyleScheme myGlobalSelected;
    private final CodeStyleSchemeImpl myProjectScheme;
    private final CodeStyleScheme myDefault;
    private final Map<CodeStyleScheme, CodeStyleSettings> mySettingsToClone = new HashMap<CodeStyleScheme, CodeStyleSettings>();
    private final EventDispatcher<CodeStyleSettingsListener> myDispatcher = EventDispatcher.create(CodeStyleSettingsListener.class);
    private final Project myProject;
    private boolean myUsePerProjectSettings;
    public static final String PROJECT_SCHEME_NAME = "Project";

    public CodeStyleSchemesModel(Project project) {
        this.myProject = project;
        this.myProjectScheme = new CodeStyleSchemeImpl(PROJECT_SCHEME_NAME, false, CodeStyleSchemes.getInstance().getDefaultScheme());
        this.reset();
        this.myDefault = CodeStyleSchemes.getInstance().getDefaultScheme();
    }

    public void selectScheme(CodeStyleScheme selected, @Nullable Object source) {
        if (this.myGlobalSelected != selected && selected != this.myProjectScheme) {
            this.myGlobalSelected = selected;
            ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(source);
        }
    }

    public void addScheme(CodeStyleScheme newScheme, boolean changeSelection) {
        this.mySchemes.add(newScheme);
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (changeSelection) {
            this.selectScheme(newScheme, this);
        }
    }

    public void removeScheme(CodeStyleScheme scheme) {
        this.mySchemes.remove(scheme);
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (this.myGlobalSelected == scheme) {
            this.selectScheme(this.myDefault, this);
        }
    }

    public CodeStyleSettings getCloneSettings(CodeStyleScheme scheme) {
        if (!this.mySettingsToClone.containsKey(scheme)) {
            this.mySettingsToClone.put(scheme, scheme.getCodeStyleSettings().clone());
        }
        return this.mySettingsToClone.get(scheme);
    }

    public CodeStyleScheme getSelectedScheme() {
        if (this.myUsePerProjectSettings) {
            return this.myProjectScheme;
        }
        return this.myGlobalSelected;
    }

    public void addListener(CodeStyleSettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public List<CodeStyleScheme> getSchemes() {
        return Collections.unmodifiableList(this.mySchemes);
    }

    public void reset() {
        this.myUsePerProjectSettings = this.getProjectSettings().USE_PER_PROJECT_SETTINGS;
        Object[] allSchemes = CodeStyleSchemes.getInstance().getSchemes();
        this.mySettingsToClone.clear();
        this.mySchemes.clear();
        ContainerUtil.addAll(this.mySchemes, (Object[])allSchemes);
        this.myGlobalSelected = CodeStyleSchemes.getInstance().findPreferredScheme(this.getProjectSettings().PREFERRED_PROJECT_CODE_STYLE);
        CodeStyleSettings perProjectSettings = this.getProjectSettings().PER_PROJECT_SETTINGS;
        if (perProjectSettings != null) {
            this.myProjectScheme.setCodeStyleSettings(perProjectSettings);
        }
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(this);
    }

    public boolean isUsePerProjectSettings() {
        return this.myUsePerProjectSettings;
    }

    public void setUsePerProjectSettings(boolean usePerProjectSettings) {
        this.setUsePerProjectSettings(usePerProjectSettings, false);
    }

    public void setUsePerProjectSettings(boolean usePerProjectSettings, boolean commit) {
        if (commit) {
            CodeStyleSettingsManager projectSettings = this.getProjectSettings();
            projectSettings.USE_PER_PROJECT_SETTINGS = usePerProjectSettings;
            projectSettings.PER_PROJECT_SETTINGS = this.myProjectScheme.getCodeStyleSettings();
        }
        if (this.myUsePerProjectSettings != usePerProjectSettings) {
            this.myUsePerProjectSettings = usePerProjectSettings;
            ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).usePerProjectSettingsOptionChanged();
            ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(this);
        }
    }

    private CodeStyleSettingsManager getProjectSettings() {
        return CodeStyleSettingsManager.getInstance((Project)this.myProject);
    }

    public boolean isSchemeListModified() {
        HashSet<CodeStyleScheme> savedSchemesSet;
        CodeStyleSchemes schemes = CodeStyleSchemes.getInstance();
        if (this.getProjectSettings().USE_PER_PROJECT_SETTINGS != this.myUsePerProjectSettings) {
            return true;
        }
        if (!this.myUsePerProjectSettings && this.getSelectedScheme() != schemes.findPreferredScheme(this.getProjectSettings().PREFERRED_PROJECT_CODE_STYLE)) {
            return true;
        }
        HashSet<CodeStyleScheme> configuredSchemesSet = new HashSet<CodeStyleScheme>(this.getSchemes());
        return !((Object)configuredSchemesSet).equals(savedSchemesSet = new HashSet<CodeStyleScheme>(Arrays.asList(schemes.getSchemes())));
    }

    public void apply() {
        CodeStyleSettingsManager projectSettingsManager = this.getProjectSettings();
        projectSettingsManager.USE_PER_PROJECT_SETTINGS = this.myUsePerProjectSettings;
        projectSettingsManager.PREFERRED_PROJECT_CODE_STYLE = this.myUsePerProjectSettings || this.myGlobalSelected == null ? null : this.myGlobalSelected.getName();
        projectSettingsManager.PER_PROJECT_SETTINGS = this.myProjectScheme.getCodeStyleSettings();
        CodeStyleScheme[] savedSchemes = CodeStyleSchemes.getInstance().getSchemes();
        HashSet<CodeStyleScheme> savedSchemesSet = new HashSet<CodeStyleScheme>(Arrays.asList(savedSchemes));
        List<CodeStyleScheme> configuredSchemes = this.getSchemes();
        for (CodeStyleScheme savedScheme : savedSchemes) {
            if (configuredSchemes.contains(savedScheme)) continue;
            CodeStyleSchemes.getInstance().deleteScheme(savedScheme);
        }
        for (CodeStyleScheme configuredScheme : configuredSchemes) {
            if (savedSchemesSet.contains(configuredScheme)) continue;
            CodeStyleSchemes.getInstance().addScheme(configuredScheme);
        }
        CodeStyleSchemes.getInstance().setCurrentScheme(this.myGlobalSelected);
        this.mySettingsToClone.clear();
    }

    public static boolean cannotBeModified(CodeStyleScheme currentScheme) {
        return currentScheme.isDefault();
    }

    public static boolean cannotBeDeleted(CodeStyleScheme currentScheme) {
        return currentScheme.isDefault();
    }

    public void fireCurrentSettingsChanged() {
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).currentSettingsChanged();
    }

    public void fireSchemeChanged(CodeStyleScheme scheme) {
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(scheme);
    }

    public CodeStyleScheme getSelectedGlobalScheme() {
        return this.myGlobalSelected;
    }

    public void copyToProject(CodeStyleScheme selectedScheme) {
        this.myProjectScheme.getCodeStyleSettings().copyFrom(selectedScheme.getCodeStyleSettings());
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this.myProjectScheme);
    }

    public CodeStyleScheme exportProjectScheme(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/codeStyle/CodeStyleSchemesModel", "exportProjectScheme"));
        }
        CodeStyleScheme newScheme = this.createNewScheme(name, this.myProjectScheme);
        ((CodeStyleSchemeImpl)newScheme).setCodeStyleSettings(this.getCloneSettings(this.myProjectScheme));
        this.addScheme(newScheme, false);
        return newScheme;
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        String name;
        if (preferredName == null) {
            if (parentScheme == null) {
                throw new IllegalArgumentException("parentScheme must not be null");
            }
            name = null;
            int i = 1;
            while (name == null) {
                String currName = parentScheme.getName() + " (" + i + ")";
                if (this.findSchemeByName(currName) == null) {
                    name = currName;
                }
                ++i;
            }
        } else {
            name = null;
            int i = 0;
            while (name == null) {
                String currName;
                String string = currName = i == 0 ? preferredName : preferredName + " (" + i + ")";
                if (this.findSchemeByName(currName) == null) {
                    name = currName;
                }
                ++i;
            }
        }
        return new CodeStyleSchemeImpl(name, false, parentScheme);
    }

    @Nullable
    private CodeStyleScheme findSchemeByName(String name) {
        for (CodeStyleScheme scheme : this.mySchemes) {
            if (!name.equals(scheme.getName())) continue;
            return scheme;
        }
        return null;
    }

    public CodeStyleScheme getProjectScheme() {
        return this.myProjectScheme;
    }

    public boolean isProjectScheme(CodeStyleScheme scheme) {
        return this.myProjectScheme == scheme;
    }

    public List<CodeStyleScheme> getAllSortedSchemes() {
        ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>();
        schemes.addAll(this.getSchemes());
        schemes.add(this.myProjectScheme);
        Collections.sort(schemes, new Comparator<CodeStyleScheme>(){

            @Override
            public int compare(CodeStyleScheme s1, CodeStyleScheme s2) {
                if (CodeStyleSchemesModel.this.isProjectScheme(s1)) {
                    return -1;
                }
                if (CodeStyleSchemesModel.this.isProjectScheme(s2)) {
                    return 1;
                }
                if (s1.isDefault()) {
                    return -1;
                }
                if (s2.isDefault()) {
                    return 1;
                }
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        return schemes;
    }

    public Project getProject() {
        return this.myProject;
    }
}

