/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.InspectDebuggerTree;
import com.intellij.debugger.ui.impl.MainWatchPanel;
import com.intellij.debugger.ui.impl.VariablesPanel;
import com.intellij.debugger.ui.impl.WatchDebuggerTree;
import com.intellij.debugger.ui.impl.WatchPanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import org.jetbrains.annotations.NotNull;

public class AddToWatchActionHandler
extends DebuggerActionHandler {
    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/actions/AddToWatchActionHandler", "isEnabled"));
        }
        DataContext context = event.getDataContext();
        DebuggerTreeNodeImpl[] selectedNodes = DebuggerAction.getSelectedNodes(context);
        boolean enabled = false;
        if (selectedNodes != null && selectedNodes.length > 0) {
            DebuggerTreePanel panel = DebuggerAction.getPanel(context);
            if (panel instanceof VariablesPanel || panel instanceof WatchPanel || panel == null && DebuggerAction.getTree(context) instanceof InspectDebuggerTree) {
                enabled = true;
                for (DebuggerTreeNodeImpl node : selectedNodes) {
                    NodeDescriptorImpl descriptor = node.getDescriptor();
                    if (descriptor instanceof ValueDescriptorImpl) continue;
                    enabled = false;
                    break;
                }
            }
        } else {
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            enabled = DebuggerUtilsEx.getEditorText(editor) != null;
        }
        return enabled;
    }

    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/actions/AddToWatchActionHandler", "perform"));
        }
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(event.getDataContext());
        if (debuggerContext == null) {
            return;
        }
        DebuggerSession session = debuggerContext.getDebuggerSession();
        if (session == null) {
            return;
        }
        MainWatchPanel watchPanel = null;
        if (watchPanel == null) {
            return;
        }
        DebuggerTreeNodeImpl[] selectedNodes = DebuggerAction.getSelectedNodes(event.getDataContext());
        if (selectedNodes != null && selectedNodes.length > 0) {
            AddToWatchActionHandler.addFromNodes(debuggerContext, watchPanel, selectedNodes);
        } else {
            TextWithImports editorText;
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor != null && (editorText = DebuggerUtilsEx.getEditorText(editor)) != null) {
                AddToWatchActionHandler.doAddWatch(watchPanel, editorText, null);
            }
        }
    }

    public static void addFromNodes(DebuggerContextImpl debuggerContext, MainWatchPanel watchPanel, DebuggerTreeNodeImpl[] selectedNodes) {
        debuggerContext.getDebugProcess().getManagerThread().schedule(new AddToWatchesCommand(debuggerContext, selectedNodes, watchPanel));
    }

    public static void doAddWatch(MainWatchPanel watchPanel, TextWithImports expression, NodeDescriptorImpl descriptor) {
        WatchDebuggerTree watchTree = watchPanel.getWatchTree();
        DebuggerTreeNodeImpl node = watchTree.addWatch(expression, null);
        if (descriptor != null) {
            node.getDescriptor().displayAs(descriptor);
        }
        node.calcValue();
    }

    private static class AddToWatchesCommand
    extends DebuggerContextCommandImpl {
        private final DebuggerContextImpl myDebuggerContext;
        private final DebuggerTreeNodeImpl[] mySelectedNodes;
        private final MainWatchPanel myWatchPanel;

        public AddToWatchesCommand(DebuggerContextImpl debuggerContext, DebuggerTreeNodeImpl[] selectedNodes, MainWatchPanel watchPanel) {
            super(debuggerContext);
            this.myDebuggerContext = debuggerContext;
            this.mySelectedNodes = selectedNodes;
            this.myWatchPanel = watchPanel;
        }

        @Override
        public void threadAction() {
            DebuggerSession session = this.myDebuggerContext.getDebuggerSession();
            if (session == null) {
                return;
            }
            final Project project = session.getProject();
            for (DebuggerTreeNodeImpl node : this.mySelectedNodes) {
                final NodeDescriptorImpl descriptor = node.getDescriptor();
                try {
                    final TextWithImports expression = DebuggerTreeNodeExpression.createEvaluationText(node, this.myDebuggerContext);
                    if (expression == null) continue;
                    DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                        @Override
                        public void run() {
                            AddToWatchActionHandler.doAddWatch(AddToWatchesCommand.this.myWatchPanel, expression, descriptor);
                        }
                    });
                }
                catch (EvaluateException e) {
                    DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)ActionsBundle.actionText((String)"Debugger.AddToWatch"));
                        }
                    });
                }
            }
        }

        @Override
        protected void commandCancelled() {
            DebuggerInvocationUtil.swingInvokeLater(this.myDebuggerContext.getProject(), new Runnable(){

                @Override
                public void run() {
                    for (DebuggerTreeNodeImpl node : AddToWatchesCommand.this.mySelectedNodes) {
                        TextWithImports expression;
                        NodeDescriptorImpl descriptor = node.getDescriptor();
                        if (!(descriptor instanceof WatchItemDescriptor) || (expression = ((WatchItemDescriptor)descriptor).getEvaluationText()) == null) continue;
                        AddToWatchActionHandler.doAddWatch(AddToWatchesCommand.this.myWatchPanel, expression, descriptor);
                    }
                }
            });
        }
    }
}

