/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.Patches;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiExpression;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ValueDescriptorImpl
extends NodeDescriptorImpl
implements ValueDescriptor {
    protected final Project myProject;
    NodeRenderer myRenderer = null;
    NodeRenderer myAutoRenderer = null;
    private Value myValue;
    private boolean myValueReady;
    private EvaluateException myValueException;
    protected EvaluationContextImpl myStoredEvaluationContext = null;
    private String myIdLabel;
    private String myValueText;
    private boolean myFullValue = false;
    @Nullable
    private Icon myValueIcon;
    protected boolean myIsNew = true;
    private boolean myIsDirty = false;
    private boolean myIsLvalue = false;
    private boolean myIsExpandable;
    private boolean myShowIdLabel = true;

    protected ValueDescriptorImpl(Project project, Value value) {
        this.myProject = project;
        this.myValue = value;
        this.myValueReady = true;
    }

    protected ValueDescriptorImpl(Project project) {
        this.myProject = project;
    }

    private void assertValueReady() {
        if (!this.myValueReady) {
            LOG.error("Value is not yet calculated for " + this.getClass());
        }
    }

    @Override
    public boolean isArray() {
        this.assertValueReady();
        return this.myValue instanceof ArrayReference;
    }

    public boolean isDirty() {
        this.assertValueReady();
        return this.myIsDirty;
    }

    @Override
    public boolean isLvalue() {
        this.assertValueReady();
        return this.myIsLvalue;
    }

    @Override
    public boolean isNull() {
        this.assertValueReady();
        return this.myValue == null;
    }

    @Override
    public boolean isString() {
        this.assertValueReady();
        return this.myValue instanceof StringReference;
    }

    @Override
    public boolean isPrimitive() {
        this.assertValueReady();
        return this.myValue instanceof PrimitiveValue;
    }

    public boolean isValueValid() {
        return this.myValueException == null;
    }

    public boolean isShowIdLabel() {
        return this.myShowIdLabel;
    }

    public void setShowIdLabel(boolean showIdLabel) {
        this.myShowIdLabel = showIdLabel;
    }

    @Override
    public Value getValue() {
        EvaluationContextImpl evalContext;
        if (Patches.IBM_JDK_DISABLE_COLLECTION_BUG && (evalContext = this.myStoredEvaluationContext) != null && !evalContext.getSuspendContext().isResumed() && this.myValue instanceof ObjectReference && VirtualMachineProxyImpl.isCollected((ObjectReference)this.myValue)) {
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            evalContext.getDebugProcess().getManagerThread().invoke(new SuspendContextCommandImpl(evalContext.getSuspendContext()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void contextAction() throws Exception {
                    try {
                        ValueDescriptorImpl.this.setContext(ValueDescriptorImpl.this.myStoredEvaluationContext);
                    }
                    finally {
                        semaphore.up();
                    }
                }

                @Override
                protected void commandCancelled() {
                    semaphore.up();
                }
            });
            semaphore.waitFor();
        }
        this.assertValueReady();
        return this.myValue;
    }

    @Override
    public boolean isExpandable() {
        return this.myIsExpandable;
    }

    public abstract Value calcValue(EvaluationContextImpl var1) throws EvaluateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setContext(EvaluationContextImpl evaluationContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myStoredEvaluationContext = evaluationContext;
        try {
            Value value;
            block10: {
                value = this.calcValue(evaluationContext);
                if (!this.myIsNew) {
                    try {
                        if (this.myValue instanceof DoubleValue && Double.isNaN(((DoubleValue)this.myValue).doubleValue())) {
                            this.myIsDirty = !(value instanceof DoubleValue);
                            break block10;
                        }
                        if (this.myValue instanceof FloatValue && Float.isNaN(((FloatValue)this.myValue).floatValue())) {
                            this.myIsDirty = !(value instanceof FloatValue);
                            break block10;
                        }
                        this.myIsDirty = value == null ? this.myValue != null : !value.equals(this.myValue);
                    }
                    catch (ObjectCollectedException ignored) {
                        this.myIsDirty = true;
                    }
                }
            }
            this.myValue = value;
            this.myValueException = null;
        }
        catch (EvaluateException e) {
            this.myValueException = e;
            this.setFailed(e);
            this.myValue = ValueDescriptorImpl.getTargetExceptionWithStackTraceFilled(evaluationContext, e);
            this.myIsExpandable = false;
        }
        finally {
            this.myValueReady = true;
        }
        this.myIsNew = false;
    }

    @Nullable
    private static ObjectReference getTargetExceptionWithStackTraceFilled(EvaluationContextImpl evaluationContext, EvaluateException ex) {
        ObjectReference exceptionObj = ex.getExceptionFromTargetVM();
        if (exceptionObj != null && evaluationContext != null) {
            try {
                ReferenceType refType = exceptionObj.referenceType();
                List<Method> methods = refType.methodsByName("getStackTrace", "()[Ljava/lang/StackTraceElement;");
                if (methods.size() > 0) {
                    ArrayReference traceArray;
                    Type componentType;
                    Value trace;
                    DebugProcessImpl process = evaluationContext.getDebugProcess();
                    process.invokeMethod((EvaluationContext)evaluationContext, exceptionObj, methods.get(0), Collections.emptyList());
                    Field traceField = refType.fieldByName("stackTrace");
                    Value value = trace = traceField != null ? exceptionObj.getValue(traceField) : null;
                    if (trace instanceof ArrayReference && (componentType = ((ArrayType)(traceArray = (ArrayReference)trace).referenceType()).componentType()) instanceof ClassType) {
                        process.printToConsole(DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)exceptionObj));
                        process.printToConsole("\n");
                        for (Value stackElement : traceArray.getValues()) {
                            process.printToConsole("\tat ");
                            process.printToConsole(DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)stackElement));
                            process.printToConsole("\n");
                        }
                    }
                }
            }
            catch (EvaluateException ignored) {
            }
            catch (ClassNotLoadedException ignored) {
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        return exceptionObj;
    }

    @Override
    public void setAncestor(NodeDescriptor oldDescriptor) {
        super.setAncestor(oldDescriptor);
        this.myIsNew = false;
        ValueDescriptorImpl other = (ValueDescriptorImpl)oldDescriptor;
        if (other.myValueReady) {
            this.myValue = other.getValue();
            this.myValueReady = true;
        }
    }

    protected void setLvalue(boolean value) {
        this.myIsLvalue = value;
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) {
        String label;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        NodeRenderer renderer = this.getRenderer(context.getDebugProcess());
        EvaluateException valueException = this.myValueException;
        this.myIsExpandable = (valueException == null || valueException.getExceptionFromTargetVM() != null) && renderer.isExpandable(this.getValue(), context, this);
        try {
            this.setValueIcon(renderer.calcValueIcon(this, context, labelListener));
        }
        catch (EvaluateException e) {
            LOG.info((Throwable)e);
            this.setValueIcon(null);
        }
        if (valueException == null) {
            try {
                label = renderer.calcLabel(this, context, labelListener);
            }
            catch (EvaluateException e) {
                label = this.setValueLabelFailed(e);
            }
        } else {
            label = this.setValueLabelFailed(valueException);
        }
        this.setValueLabel(label);
        return "";
    }

    private String calcIdLabel() {
        if (this.isShowIdLabel() && this.myValueReady) {
            Value value = this.getValue();
            Renderer lastRenderer = this.getLastRenderer();
            EvaluationContextImpl evalContext = this.myStoredEvaluationContext;
            return evalContext != null && lastRenderer != null && !evalContext.getSuspendContext().isResumed() ? ((NodeRendererImpl)lastRenderer).getIdLabel(value, evalContext.getDebugProcess()) : null;
        }
        return null;
    }

    @Override
    public String getLabel() {
        return this.calcValueName() + " = " + this.getValueLabel();
    }

    public ValueDescriptorImpl getFullValueDescriptor() {
        ValueDescriptorImpl descriptor = new ValueDescriptorImpl(this.myProject, this.myValue){

            @Override
            public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
                return ValueDescriptorImpl.this.myValue;
            }

            @Override
            public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
                return null;
            }
        };
        descriptor.myFullValue = true;
        return descriptor;
    }

    @Override
    public void setValueLabel(String label) {
        if (!this.myFullValue) {
            label = DebuggerUtilsEx.truncateString(label);
        }
        this.myValueText = label;
        this.myIdLabel = this.calcIdLabel();
    }

    @Override
    public String setValueLabelFailed(EvaluateException e) {
        String label = this.setFailed(e);
        this.setValueLabel(label);
        return label;
    }

    @Override
    public Icon setValueIcon(Icon icon) {
        this.myValueIcon = icon;
        return this.myValueIcon;
    }

    @Nullable
    public Icon getValueIcon() {
        return this.myValueIcon;
    }

    public String calcValueName() {
        return this.getName();
    }

    @Override
    public void displayAs(NodeDescriptor descriptor) {
        if (descriptor instanceof ValueDescriptorImpl) {
            ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
            this.myRenderer = valueDescriptor.myRenderer;
        }
        super.displayAs(descriptor);
    }

    public Renderer getLastRenderer() {
        return this.myRenderer != null ? this.myRenderer : this.myAutoRenderer;
    }

    @Nullable
    public Type getType() {
        Value value = this.getValue();
        return value != null ? value.type() : null;
    }

    public NodeRenderer getRenderer(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Type type = this.getType();
        if (type != null && this.myRenderer != null && this.myRenderer.isApplicable(type)) {
            return this.myRenderer;
        }
        this.myAutoRenderer = debugProcess.getAutoRenderer(this);
        return this.myAutoRenderer;
    }

    public void setRenderer(NodeRenderer renderer) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myRenderer = renderer;
        this.myAutoRenderer = null;
    }

    @Nullable
    public PsiExpression getTreeEvaluation(JavaValue value, DebuggerContextImpl context) throws EvaluateException {
        if (value.getParent() != null) {
            ValueDescriptorImpl descriptor = value.getParent().getDescriptor();
            ValueDescriptorImpl vDescriptor = descriptor;
            PsiExpression parentEvaluation = vDescriptor.getTreeEvaluation(value.getParent(), context);
            if (parentEvaluation == null) {
                return null;
            }
            return DebuggerTreeNodeExpression.substituteThis(vDescriptor.getRenderer(context.getDebugProcess()).getChildValueExpression(new DebuggerTreeNodeMock(value), context), parentEvaluation, vDescriptor.getValue());
        }
        return this.getDescriptorEvaluation(context);
    }

    @Override
    public abstract PsiExpression getDescriptorEvaluation(DebuggerContext var1) throws EvaluateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIdLabel(ObjectReference objRef) {
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            int idx;
            boolean showConcreteType;
            ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
            boolean bl = showConcreteType = !classRenderer.SHOW_DECLARED_TYPE || !(objRef instanceof StringReference) && !(objRef instanceof ClassObjectReference) && !ValueDescriptorImpl.isEnumConstant(objRef);
            if (showConcreteType || classRenderer.SHOW_OBJECT_ID) {
                if (showConcreteType) {
                    buf.append(classRenderer.renderTypeName(objRef.type().name()));
                }
                if (classRenderer.SHOW_OBJECT_ID) {
                    buf.append('@');
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        buf.append("uniqueID");
                    } else {
                        buf.append(objRef.uniqueID());
                    }
                }
            }
            if (objRef instanceof ArrayReference && (idx = buf.indexOf("[")) >= 0) {
                buf.insert(idx + 1, Integer.toString(((ArrayReference)objRef).length()));
            }
            String string = buf.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    private static boolean isEnumConstant(ObjectReference objRef) {
        Type type = objRef.type();
        return type instanceof ClassType && ((ClassType)type).isEnum();
    }

    public boolean canSetValue() {
        return this.myValueReady && !this.myIsSynthetic && this.isLvalue();
    }

    @NotNull
    public String getIdLabel() {
        String string = StringUtil.notNullize((String)this.myIdLabel);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/ValueDescriptorImpl", "getIdLabel"));
        }
        return string;
    }

    public String getValueLabel() {
        String label = this.getIdLabel();
        if (!StringUtil.isEmpty((String)label)) {
            return '{' + label + '}' + this.getValueText();
        }
        return this.getValueText();
    }

    @NotNull
    public String getValueText() {
        String string = StringUtil.notNullize((String)this.myValueText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/ValueDescriptorImpl", "getValueText"));
        }
        return string;
    }

    @Override
    public void clear() {
        super.clear();
        this.setValueLabel("");
        this.myIsExpandable = false;
    }

    @Override
    @Nullable
    public ValueMarkup getMarkup(DebugProcess debugProcess) {
        Value value = this.getValue();
        if (value instanceof ObjectReference) {
            ObjectReference objRef = (ObjectReference)value;
            Map<ObjectReference, ValueMarkup> map = ValueDescriptorImpl.getMarkupMap(debugProcess);
            if (map != null) {
                return map.get(objRef);
            }
        }
        return null;
    }

    @Override
    public void setMarkup(DebugProcess debugProcess, @Nullable ValueMarkup markup) {
        Map<ObjectReference, ValueMarkup> map;
        Value value = this.getValue();
        if (value instanceof ObjectReference && (map = ValueDescriptorImpl.getMarkupMap(debugProcess)) != null) {
            ObjectReference objRef = (ObjectReference)value;
            if (markup != null) {
                map.put(objRef, markup);
            } else {
                map.remove(objRef);
            }
        }
    }

    public boolean canMark() {
        if (!this.myValueReady) {
            return false;
        }
        return this.getValue() instanceof ObjectReference;
    }

    public Project getProject() {
        return this.myProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addDeclaredType(String typeName) {
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            buf.append(this.getName()).append(": ").append(classRenderer.renderTypeName(typeName));
            String string = buf.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    private static class DebuggerTreeNodeMock
    implements DebuggerTreeNode {
        private final JavaValue value;

        public DebuggerTreeNodeMock(JavaValue value) {
            this.value = value;
        }

        @Override
        public DebuggerTreeNode getParent() {
            return new DebuggerTreeNodeMock(this.value.getParent());
        }

        @Override
        public ValueDescriptorImpl getDescriptor() {
            return this.value.getDescriptor();
        }

        @Override
        public Project getProject() {
            return this.value.getProject();
        }

        @Override
        public void setRenderer(NodeRenderer renderer) {
        }
    }
}

