/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackTreeLayer;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentEditableArea
implements EditableArea {
    private final JComponent myComponent;
    private final EventListenerList myListenerList = new EventListenerList();
    private List<RadComponent> mySelection = new ArrayList<RadComponent>();

    public ComponentEditableArea(JComponent component) {
        this.myComponent = component;
    }

    @Override
    public void addSelectionListener(ComponentSelectionListener listener) {
        this.myListenerList.add(ComponentSelectionListener.class, listener);
    }

    @Override
    public void removeSelectionListener(ComponentSelectionListener listener) {
        this.myListenerList.remove(ComponentSelectionListener.class, listener);
    }

    protected void fireSelectionChanged() {
        for (ComponentSelectionListener listener : (ComponentSelectionListener[])this.myListenerList.getListeners(ComponentSelectionListener.class)) {
            listener.selectionChanged(this);
        }
    }

    @Override
    @NotNull
    public List<RadComponent> getSelection() {
        List<RadComponent> list = this.mySelection;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/designSurface/ComponentEditableArea", "getSelection"));
        }
        return list;
    }

    @Override
    public boolean isSelected(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/designer/designSurface/ComponentEditableArea", "isSelected"));
        }
        return this.mySelection.contains(component);
    }

    @Override
    public void select(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/designer/designSurface/ComponentEditableArea", "select"));
        }
        this.mySelection = new ArrayList<RadComponent>();
        this.mySelection.add(component);
        this.fireSelectionChanged();
    }

    @Override
    public void deselect(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/designer/designSurface/ComponentEditableArea", "deselect"));
        }
        this.mySelection.remove(component);
        this.fireSelectionChanged();
    }

    @Override
    public void appendSelection(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/designer/designSurface/ComponentEditableArea", "appendSelection"));
        }
        this.mySelection.remove(component);
        this.mySelection.add(component);
        this.fireSelectionChanged();
    }

    @Override
    public void setSelection(@NotNull List<RadComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/designer/designSurface/ComponentEditableArea", "setSelection"));
        }
        this.mySelection = new ArrayList<RadComponent>(components);
        this.fireSelectionChanged();
    }

    @Override
    public void deselect(@NotNull Collection<RadComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/designer/designSurface/ComponentEditableArea", "deselect"));
        }
        this.mySelection.removeAll(components);
        this.fireSelectionChanged();
    }

    @Override
    public void deselectAll() {
        this.mySelection = new ArrayList<RadComponent>();
        this.fireSelectionChanged();
    }

    @Override
    public void scrollToSelection() {
    }

    @Override
    public void setCursor(@Nullable Cursor cursor) {
        this.myComponent.setCursor(cursor);
    }

    @Override
    public void setDescription(@Nullable String text) {
        ActionMenu.showDescriptionInStatusBar(true, this.myComponent, text);
    }

    @Override
    @NotNull
    public JComponent getNativeComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/designSurface/ComponentEditableArea", "getNativeComponent"));
        }
        return jComponent;
    }

    @Override
    public boolean isTree() {
        return false;
    }

    @Override
    @Nullable
    public FeedbackTreeLayer getFeedbackTreeLayer() {
        return null;
    }
}

