/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.filechooser.FileSystemView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowFilePathAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ShowFilePathAction");
    public static final NotificationListener FILE_SELECTING_LISTENER = new NotificationListener.Adapter(){

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/ide/actions/ShowFilePathAction$1", "hyperlinkActivated"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ShowFilePathAction$1", "hyperlinkActivated"));
            }
            URL url = e.getURL();
            if (url != null) {
                ShowFilePathAction.openFile(new File(url.getPath()));
            }
            notification.expire();
        }
    };
    private static NotNullLazyValue<Boolean> canUseNautilus = new NotNullLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            if (!(SystemInfo.isUnix && SystemInfo.hasXdgMime() && new File("/usr/bin/nautilus").canExecute())) {
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$2", "compute"));
                }
                return bl;
            }
            String appName = ExecUtil.execAndReadLine((String[])new String[]{"xdg-mime", "query", "default", "inode/directory"});
            if (appName == null || !appName.matches("nautilus.*\\.desktop")) {
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$2", "compute"));
                }
                return bl;
            }
            String version = ExecUtil.execAndReadLine((String[])new String[]{"nautilus", "--version"});
            if (version == null) {
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$2", "compute"));
                }
                return bl;
            }
            Matcher m = Pattern.compile("GNOME nautilus ([0-9.]+)").matcher(version);
            Boolean bl = m.find() && StringUtil.compareVersionNumbers((String)m.group(1), (String)"3") >= 0;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$2", "compute"));
            }
            return bl;
        }
    };
    private static final NotNullLazyValue<String> fileManagerName = new AtomicNotNullLazyValue<String>(){

        @NotNull
        protected String compute() {
            String name;
            if (SystemInfo.isMac) {
                if ("Finder" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$3", "compute"));
                }
                return "Finder";
            }
            if (SystemInfo.isWindows) {
                if ("Explorer" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$3", "compute"));
                }
                return "Explorer";
            }
            if (SystemInfo.isUnix && SystemInfo.hasXdgMime() && (name = ShowFilePathAction.getUnixFileManagerName()) != null) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$3", "compute"));
                }
                return string;
            }
            if ("File Manager" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$3", "compute"));
            }
            return "File Manager";
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getUnixFileManagerName() {
        String appName = ExecUtil.execAndReadLine((String[])new String[]{"xdg-mime", "query", "default", "inode/directory"});
        if (appName == null) return null;
        if (!appName.matches(".+\\.desktop")) {
            return null;
        }
        String dirs = System.getenv("XDG_DATA_DIRS");
        if (dirs == null) {
            return null;
        }
        try {
            String[] arr$ = dirs.split(File.pathSeparator);
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                String dir = arr$[i$];
                File appFile = new File(dir, "applications/" + appName);
                if (appFile.exists()) {
                    BufferedReader reader = new BufferedReader(new FileReader(appFile));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (!line.startsWith("Name=")) continue;
                            String string = line.substring(5);
                            return string;
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                ++i$;
            }
            return null;
        }
        catch (IOException e) {
            LOG.info("Cannot read desktop file", (Throwable)e);
        }
        return null;
    }

    public void update(AnActionEvent e) {
        if (SystemInfo.isMac || !ShowFilePathAction.isSupported()) {
            e.getPresentation().setVisible(false);
            return;
        }
        e.getPresentation().setEnabled(ShowFilePathAction.getFile(e) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        ShowFilePathAction.show(ShowFilePathAction.getFile(e), new ShowAction(){

            @Override
            public void show(final ListPopup popup) {
                DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>(){

                    public void consume(DataContext context) {
                        popup.showInBestPositionFor(context);
                    }
                });
            }
        });
    }

    public static void show(VirtualFile file, final MouseEvent e) {
        ShowFilePathAction.show(file, new ShowAction(){

            @Override
            public void show(ListPopup popup) {
                if (e.getComponent().isShowing()) {
                    popup.show(new RelativePoint(e));
                }
            }
        });
    }

    public static void show(VirtualFile file, final ShowAction show) {
        if (!ShowFilePathAction.isSupported()) {
            return;
        }
        final ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        final ArrayList<String> fileUrls = new ArrayList<String>();
        for (VirtualFile eachParent = file; eachParent != null; eachParent = eachParent.getParent()) {
            int index = files.size() == 0 ? 0 : files.size();
            files.add(index, eachParent);
            fileUrls.add(index, ShowFilePathAction.getPresentableUrl(eachParent));
            if (eachParent.getParent() == null && eachParent.getFileSystem() instanceof JarFileSystem && (eachParent = JarFileSystem.getInstance().getVirtualFileForJar(eachParent)) == null) break;
        }
        final ArrayList icons = new ArrayList();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                for (String each : fileUrls) {
                    File ioFile = new File(each);
                    Icon eachIcon = ioFile.exists() ? FileSystemView.getFileSystemView().getSystemIcon(ioFile) : EmptyIcon.ICON_16;
                    icons.add(eachIcon);
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        show.show(ShowFilePathAction.createPopup(files, icons));
                    }
                });
            }
        });
    }

    private static String getPresentableUrl(VirtualFile eachParent) {
        String url = eachParent.getPresentableUrl();
        if (eachParent.getParent() == null && SystemInfo.isWindows) {
            url = url + "\\";
        }
        return url;
    }

    private static ListPopup createPopup(ArrayList<VirtualFile> files, ArrayList<Icon> icons) {
        BaseListPopupStep<VirtualFile> step = new BaseListPopupStep<VirtualFile>("File Path", files, icons){

            @NotNull
            public String getTextFor(VirtualFile value) {
                String string = value.getPresentableName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$7", "getTextFor"));
                }
                return string;
            }

            public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
                final File selectedFile = new File(ShowFilePathAction.getPresentableUrl(selectedValue));
                if (selectedFile.exists()) {
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            ShowFilePathAction.openFile(selectedFile);
                        }
                    });
                }
                return FINAL_CHOICE;
            }
        };
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
    }

    public static boolean isSupported() {
        return SystemInfo.isWindows || SystemInfo.hasXdgOpen() || (Boolean)canUseNautilus.getValue() != false || Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    @NotNull
    public static String getFileManagerName() {
        String string = (String)fileManagerName.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction", "getFileManagerName"));
        }
        return string;
    }

    public static void openFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/ShowFilePathAction", "openFile"));
        }
        if (!file.exists()) {
            return;
        }
        File parent = (file = file.getAbsoluteFile()).getParentFile();
        if (parent == null) {
            return;
        }
        try {
            ShowFilePathAction.doOpen(parent, file);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    public static void openDirectory(@NotNull File directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/actions/ShowFilePathAction", "openDirectory"));
        }
        if (!directory.isDirectory()) {
            return;
        }
        try {
            ShowFilePathAction.doOpen(directory, null);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    private static void doOpen(@NotNull File dir, @Nullable File toSelect) throws IOException, ExecutionException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/ide/actions/ShowFilePathAction", "doOpen"));
        }
        dir = new File(FileUtil.toCanonicalPath((String)dir.getPath()));
        File file = toSelect = toSelect == null ? null : new File(FileUtil.toCanonicalPath((String)toSelect.getPath()));
        if (SystemInfo.isWindows) {
            String cmd = toSelect != null ? "explorer /select," + toSelect.getAbsolutePath() : "explorer /root," + dir.getAbsolutePath();
            Runtime.getRuntime().exec(cmd);
            return;
        }
        if (SystemInfo.isMac) {
            if (toSelect != null) {
                String script = String.format("tell application \"Finder\"\n\treveal {\"%s\"} as POSIX file\n\tactivate\nend tell", toSelect.getAbsolutePath());
                new GeneralCommandLine(new String[]{ExecUtil.getOsascriptPath(), "-e", script}).createProcess();
            } else {
                new GeneralCommandLine(new String[]{"open", dir.getAbsolutePath()}).createProcess();
            }
            return;
        }
        if (((Boolean)canUseNautilus.getValue()).booleanValue()) {
            new GeneralCommandLine(new String[]{"nautilus", (toSelect != null ? toSelect : dir).getAbsolutePath()}).createProcess();
            return;
        }
        String path = dir.getAbsolutePath();
        if (SystemInfo.hasXdgOpen()) {
            new GeneralCommandLine(new String[]{"/usr/bin/xdg-open", path}).createProcess();
        } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            Desktop.getDesktop().open(new File(path));
        } else {
            Messages.showErrorDialog((String)"This action isn't supported on the current platform", (String)"Cannot Open File");
        }
    }

    @Nullable
    private static VirtualFile getFile(AnActionEvent e) {
        return (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
    }

    public static Boolean showDialog(Project project, String message, String title, File file) {
        final Boolean[] ref = new Boolean[1];
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return true;
            }

            public void setToBeShown(boolean value, int exitCode) {
                if (!value) {
                    ref[0] = exitCode == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$8", "getDoNotShowMessage"));
                }
                return string;
            }
        };
        ShowFilePathAction.showDialog(project, message, title, file, option);
        return ref[0];
    }

    public static void showDialog(Project project, String message, String title, File file, DialogWrapper.DoNotAskOption option) {
        if (Messages.showOkCancelDialog((Project)project, (String)message, (String)title, (String)RevealFileAction.getActionName(), (String)IdeBundle.message((String)"action.close", (Object[])new Object[0]), (Icon)Messages.getInformationIcon(), (DialogWrapper.DoNotAskOption)option) == 0) {
            ShowFilePathAction.openFile(file);
        }
    }

    @Nullable
    public static VirtualFile findLocalFile(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        if (file.isInLocalFileSystem()) {
            return file;
        }
        VirtualFileSystem fs = file.getFileSystem();
        if (fs instanceof JarFileSystem && file.getParent() == null) {
            return ((JarFileSystem)fs).getLocalVirtualFileFor(file);
        }
        return null;
    }

    static interface ShowAction {
        public void show(ListPopup var1);
    }
}

