/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.util.TreeChooser;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeClassChooserDialog<T extends PsiNamedElement>
extends DialogWrapper
implements TreeChooser<T> {
    @NotNull
    private final Project myProject;
    private final GlobalSearchScope myScope;
    @NotNull
    private final TreeChooser.Filter<T> myClassFilter;
    private final Class<T> myElementClass;
    @Nullable
    private final T myBaseClass;
    private final boolean myIsShowMembers;
    private final boolean myIsShowLibraryContents;
    private Tree myTree;
    private T mySelectedClass;
    private BaseProjectTreeBuilder myBuilder;
    private TabbedPaneWrapper myTabbedPane;
    private ChooseByNamePanel myGotoByNamePanel;
    private T myInitialClass;

    public AbstractTreeClassChooserDialog(String title, Project project, Class<T> elementClass) {
        this(title, project, elementClass, null);
    }

    public AbstractTreeClassChooserDialog(String title, Project project, Class<T> elementClass, @Nullable T initialClass) {
        this(title, project, GlobalSearchScope.projectScope((Project)project), elementClass, null, initialClass);
    }

    public AbstractTreeClassChooserDialog(String title, @NotNull Project project, GlobalSearchScope scope, @NotNull Class<T> elementClass, @Nullable TreeChooser.Filter<T> classFilter, @Nullable T initialClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/AbstractTreeClassChooserDialog", "<init>"));
        }
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/ide/util/AbstractTreeClassChooserDialog", "<init>"));
        }
        this(title, project, scope, (Class<Object>)elementClass, (TreeChooser.Filter<Object>)classFilter, null, initialClass, false, true);
    }

    public AbstractTreeClassChooserDialog(String title, @NotNull Project project, GlobalSearchScope scope, @NotNull Class<T> elementClass, @Nullable TreeChooser.Filter<T> classFilter, @Nullable T baseClass, @Nullable T initialClass, boolean isShowMembers, boolean isShowLibraryContents) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/AbstractTreeClassChooserDialog", "<init>"));
        }
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/ide/util/AbstractTreeClassChooserDialog", "<init>"));
        }
        super(project, true);
        this.mySelectedClass = null;
        this.myScope = scope;
        this.myElementClass = elementClass;
        this.myClassFilter = classFilter == null ? this.allFilter() : classFilter;
        this.myBaseClass = baseClass;
        this.myInitialClass = initialClass;
        this.myIsShowMembers = isShowMembers;
        this.myIsShowLibraryContents = isShowLibraryContents;
        this.setTitle(title);
        this.myProject = project;
        this.init();
        if (initialClass != null) {
            this.select(initialClass);
        }
        this.handleSelectionChanged();
    }

    private TreeChooser.Filter<T> allFilter() {
        return new TreeChooser.Filter<T>(){

            public boolean isAccepted(T element) {
                return true;
            }
        };
    }

    protected JComponent createCenterPanel() {
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)model);
        AbstractProjectTreeStructure treeStructure = new AbstractProjectTreeStructure(this.myProject){

            public boolean isFlattenPackages() {
                return false;
            }

            @Override
            public boolean isShowMembers() {
                return AbstractTreeClassChooserDialog.this.myIsShowMembers;
            }

            public boolean isHideEmptyMiddlePackages() {
                return true;
            }

            public boolean isAbbreviatePackageNames() {
                return false;
            }

            public boolean isShowLibraryContents() {
                return AbstractTreeClassChooserDialog.this.myIsShowLibraryContents;
            }

            public boolean isShowModules() {
                return false;
            }
        };
        this.myBuilder = new ProjectTreeBuilder(this.myProject, (JTree)this.myTree, model, (Comparator<NodeDescriptor>)AlphaComparator.INSTANCE, treeStructure);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.expandRow(0);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)500, (int)300));
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    AbstractTreeClassChooserDialog.this.doOKAction();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                TreePath path = AbstractTreeClassChooserDialog.this.myTree.getPathForLocation(event.getX(), event.getY());
                if (path != null && AbstractTreeClassChooserDialog.this.myTree.isPathSelected(path)) {
                    AbstractTreeClassChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myTree);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AbstractTreeClassChooserDialog.this.handleSelectionChanged();
            }
        });
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTabbedPane = new TabbedPaneWrapper(this.getDisposable());
        final JPanel dummyPanel = new JPanel(new BorderLayout());
        String name = null;
        this.myGotoByNamePanel = new ChooseByNamePanel(this.myProject, this.createChooseByNameModel(), name, this.myScope.isSearchInLibraries(), (PsiElement)this.getContext()){

            @Override
            protected void showTextFieldPanel() {
            }

            @Override
            protected void close(boolean isOk) {
                super.close(isOk);
                if (isOk) {
                    AbstractTreeClassChooserDialog.this.doOKAction();
                } else {
                    AbstractTreeClassChooserDialog.this.doCancelAction();
                }
            }

            @Override
            @NotNull
            protected Set<Object> filter(@NotNull Set<Object> elements) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/AbstractTreeClassChooserDialog$6", "filter"));
                }
                Set set = AbstractTreeClassChooserDialog.this.doFilter(elements);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/AbstractTreeClassChooserDialog$6", "filter"));
                }
                return set;
            }

            @Override
            protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
                super.initUI(callback, modalityState, allowMultipleSelection);
                dummyPanel.add((Component)AbstractTreeClassChooserDialog.this.myGotoByNamePanel.getPanel(), "Center");
                IdeFocusTraversalPolicy.getPreferredFocusedComponent(AbstractTreeClassChooserDialog.this.myGotoByNamePanel.getPanel()).requestFocus();
            }

            @Override
            protected void showList() {
                super.showList();
                if (AbstractTreeClassChooserDialog.this.myInitialClass != null && this.myList.getModel().getSize() > 0) {
                    this.myList.setSelectedValue(AbstractTreeClassChooserDialog.this.myInitialClass, true);
                    AbstractTreeClassChooserDialog.this.myInitialClass = null;
                }
            }

            @Override
            protected void chosenElementMightChange() {
                AbstractTreeClassChooserDialog.this.handleSelectionChanged();
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myGotoByNamePanel);
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.search.by.name", (Object[])new Object[0]), dummyPanel);
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.project", (Object[])new Object[0]), scrollPane);
        this.myGotoByNamePanel.invoke(new MyCallback(), this.getModalityState(), false);
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractTreeClassChooserDialog.this.handleSelectionChanged();
            }
        });
        return this.myTabbedPane.getComponent();
    }

    private Set<Object> doFilter(Set<Object> elements) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (Object o : elements) {
            if (!this.myElementClass.isInstance(o) || !this.getFilter().isAccepted((Object)((PsiNamedElement)o))) continue;
            result.add(o);
        }
        return result;
    }

    protected ChooseByNameModel createChooseByNameModel() {
        if (this.myBaseClass == null) {
            return new MyGotoClassModel(this.myProject, this);
        }
        BaseClassInheritorsProvider<T> inheritorsProvider = this.getInheritorsProvider(this.myBaseClass);
        if (inheritorsProvider != null) {
            return new SubclassGotoClassModel<T>(this.myProject, this, inheritorsProvider);
        }
        throw new IllegalStateException("inheritors provider is null");
    }

    @Nullable
    protected BaseClassInheritorsProvider<T> getInheritorsProvider(@NotNull T baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/ide/util/AbstractTreeClassChooserDialog", "getInheritorsProvider"));
        }
        return null;
    }

    private void handleSelectionChanged() {
        T selection = this.calcSelectedClass();
        this.setOKActionEnabled(selection != null);
    }

    protected void doOKAction() {
        this.mySelectedClass = this.calcSelectedClass();
        if (this.mySelectedClass == null) {
            return;
        }
        if (!this.myClassFilter.isAccepted(this.mySelectedClass)) {
            Messages.showErrorDialog((Component)this.myTabbedPane.getComponent(), (String)(SymbolPresentationUtil.getSymbolPresentableText(this.mySelectedClass) + " is not acceptable"));
            return;
        }
        super.doOKAction();
    }

    public T getSelected() {
        return this.mySelectedClass;
    }

    public void select(@NotNull T aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/ide/util/AbstractTreeClassChooserDialog", "select"));
        }
        this.selectElementInTree((PsiElement)aClass);
    }

    public void selectDirectory(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/util/AbstractTreeClassChooserDialog", "selectDirectory"));
        }
        this.selectElementInTree((PsiElement)directory);
    }

    public void showDialog() {
        this.show();
    }

    public void showPopup() {
        ChooseByNamePopup popup = ChooseByNamePopup.createPopup(this.myProject, this.createChooseByNameModel(), this.getContext());
        popup.invoke(new ChooseByNamePopupComponent.Callback(){

            public void elementChosen(Object element) {
                AbstractTreeClassChooserDialog.this.mySelectedClass = (PsiNamedElement)element;
                ((Navigatable)element).navigate(true);
            }
        }, this.getModalityState(), true);
    }

    private T getContext() {
        return (T)(this.myBaseClass != null ? this.myBaseClass : (this.myInitialClass != null ? this.myInitialClass : null));
    }

    private void selectElementInTree(final @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/AbstractTreeClassChooserDialog", "selectElementInTree"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AbstractTreeClassChooserDialog.this.myBuilder == null) {
                    return;
                }
                VirtualFile vFile = PsiUtilBase.getVirtualFile((PsiElement)element);
                AbstractTreeClassChooserDialog.this.myBuilder.select(element, vFile, false);
            }
        }, this.getModalityState());
    }

    private ModalityState getModalityState() {
        return ModalityState.stateForComponent((Component)this.getRootPane());
    }

    @Nullable
    protected T calcSelectedClass() {
        if (this.getTabbedPane().getSelectedIndex() == 0) {
            return (T)((PsiNamedElement)this.getGotoByNamePanel().getChosenElement());
        }
        TreePath path = this.getTree().getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return this.getSelectedFromTreeUserObject(node);
    }

    protected abstract T getSelectedFromTreeUserObject(DefaultMutableTreeNode var1);

    public void dispose() {
        if (this.myBuilder != null) {
            Disposer.dispose((Disposable)this.myBuilder);
            this.myBuilder = null;
        }
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.TreeClassChooserDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGotoByNamePanel.getPreferredFocusedComponent();
    }

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/AbstractTreeClassChooserDialog", "getProject"));
        }
        return project;
    }

    GlobalSearchScope getScope() {
        return this.myScope;
    }

    @NotNull
    protected TreeChooser.Filter<T> getFilter() {
        TreeChooser.Filter<T> filter = this.myClassFilter;
        if (filter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/AbstractTreeClassChooserDialog", "getFilter"));
        }
        return filter;
    }

    T getBaseClass() {
        return this.myBaseClass;
    }

    T getInitialClass() {
        return this.myInitialClass;
    }

    protected TabbedPaneWrapper getTabbedPane() {
        return this.myTabbedPane;
    }

    protected Tree getTree() {
        return this.myTree;
    }

    protected ChooseByNamePanel getGotoByNamePanel() {
        return this.myGotoByNamePanel;
    }

    @NotNull
    protected abstract List<T> getClassesByName(String var1, boolean var2, String var3, GlobalSearchScope var4);

    private class MyCallback
    extends ChooseByNamePopupComponent.Callback {
        private MyCallback() {
        }

        public void elementChosen(Object element) {
            AbstractTreeClassChooserDialog.this.mySelectedClass = (PsiNamedElement)element;
            AbstractTreeClassChooserDialog.this.close(0);
        }
    }

    private static class SubclassGotoClassModel<T extends PsiNamedElement>
    extends MyGotoClassModel<T> {
        private final BaseClassInheritorsProvider<T> myInheritorsProvider;
        private boolean myFastMode;

        public SubclassGotoClassModel(@NotNull Project project, @NotNull AbstractTreeClassChooserDialog<T> treeClassChooserDialog, @NotNull BaseClassInheritorsProvider<T> inheritorsProvider) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/AbstractTreeClassChooserDialog$SubclassGotoClassModel", "<init>"));
            }
            if (treeClassChooserDialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeClassChooserDialog", "com/intellij/ide/util/AbstractTreeClassChooserDialog$SubclassGotoClassModel", "<init>"));
            }
            if (inheritorsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritorsProvider", "com/intellij/ide/util/AbstractTreeClassChooserDialog$SubclassGotoClassModel", "<init>"));
            }
            super(project, treeClassChooserDialog);
            this.myFastMode = true;
            this.myInheritorsProvider = inheritorsProvider;
            assert (this.myInheritorsProvider.getBaseClass() != null);
        }

        @Override
        public void processNames(final Processor<String> nameProcessor, boolean checkBoxState) {
            if (this.myFastMode) {
                this.myFastMode = this.myInheritorsProvider.searchForInheritorsOfBaseClass().forEach(new Processor<T>(){
                    private long start = System.currentTimeMillis();

                    public boolean process(T aClass) {
                        if (System.currentTimeMillis() - this.start > 500L) {
                            return false;
                        }
                        if (SubclassGotoClassModel.this.getTreeClassChooserDialog().getFilter().isAccepted(aClass) && aClass.getName() != null) {
                            nameProcessor.process((Object)aClass.getName());
                        }
                        return true;
                    }
                });
            }
            if (!this.myFastMode) {
                for (String name : this.myInheritorsProvider.getNames()) {
                    nameProcessor.process((Object)name);
                }
            }
        }

        @Override
        protected boolean isAccepted(T aClass) {
            if (this.myFastMode) {
                return this.getTreeClassChooserDialog().getFilter().isAccepted(aClass);
            }
            return (aClass == this.getTreeClassChooserDialog().getBaseClass() || this.myInheritorsProvider.isInheritorOfBaseClass(aClass)) && this.getTreeClassChooserDialog().getFilter().isAccepted(aClass);
        }
    }

    public static abstract class BaseClassInheritorsProvider<T> {
        private final T myBaseClass;
        private final GlobalSearchScope myScope;

        public BaseClassInheritorsProvider(T baseClass, GlobalSearchScope scope) {
            this.myBaseClass = baseClass;
            this.myScope = scope;
        }

        public T getBaseClass() {
            return this.myBaseClass;
        }

        public GlobalSearchScope getScope() {
            return this.myScope;
        }

        @NotNull
        protected abstract Query<T> searchForInheritors(T var1, GlobalSearchScope var2, boolean var3);

        protected abstract boolean isInheritor(T var1, T var2, boolean var3);

        protected abstract String[] getNames();

        protected Query<T> searchForInheritorsOfBaseClass() {
            return this.searchForInheritors(this.myBaseClass, this.myScope, true);
        }

        protected boolean isInheritorOfBaseClass(T aClass) {
            return this.isInheritor(aClass, this.myBaseClass, true);
        }
    }

    protected static class MyGotoClassModel<T extends PsiNamedElement>
    extends GotoClassModel2 {
        private final AbstractTreeClassChooserDialog<T> myTreeClassChooserDialog;

        public MyGotoClassModel(@NotNull Project project, AbstractTreeClassChooserDialog<T> treeClassChooserDialog) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/AbstractTreeClassChooserDialog$MyGotoClassModel", "<init>"));
            }
            super(project);
            this.myTreeClassChooserDialog = treeClassChooserDialog;
        }

        AbstractTreeClassChooserDialog<T> getTreeClassChooserDialog() {
            return this.myTreeClassChooserDialog;
        }

        @Override
        @NotNull
        public Object[] getElementsByName(String name, FindSymbolParameters parameters, @NotNull ProgressIndicator canceled) {
            if (canceled == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canceled", "com/intellij/ide/util/AbstractTreeClassChooserDialog$MyGotoClassModel", "getElementsByName"));
            }
            String patternName = parameters.getLocalPatternName();
            List<T> classes = this.myTreeClassChooserDialog.getClassesByName(name, parameters.isSearchInLibraries(), patternName, this.myTreeClassChooserDialog.getScope());
            if (classes.size() == 0) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/AbstractTreeClassChooserDialog$MyGotoClassModel", "getElementsByName"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            if (classes.size() == 1) {
                Object[] objectArray = this.isAccepted((PsiNamedElement)classes.get(0)) ? ArrayUtil.toObjectArray(classes) : ArrayUtil.EMPTY_OBJECT_ARRAY;
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/AbstractTreeClassChooserDialog$MyGotoClassModel", "getElementsByName"));
                }
                return objectArray;
            }
            HashSet qNames = ContainerUtil.newHashSet();
            ArrayList<PsiNamedElement> list = new ArrayList<PsiNamedElement>(classes.size());
            for (PsiNamedElement aClass : classes) {
                if (!qNames.add(this.getFullName(aClass)) || !this.isAccepted(aClass)) continue;
                list.add(aClass);
            }
            Object[] objectArray = ArrayUtil.toObjectArray(list);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/AbstractTreeClassChooserDialog$MyGotoClassModel", "getElementsByName"));
            }
            return objectArray;
        }

        @Override
        @Nullable
        public String getPromptText() {
            return null;
        }

        protected boolean isAccepted(T aClass) {
            return this.myTreeClassChooserDialog.getFilter().isAccepted(aClass);
        }
    }
}

