/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.framework.FrameworkOrGroup;
import com.intellij.ide.util.newProjectWizard.FrameworkGroupNode;
import com.intellij.ui.CheckedTreeNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkSupportNodeBase<T extends FrameworkOrGroup>
extends CheckedTreeNode {
    private final FrameworkSupportNodeBase myParentNode;

    public FrameworkSupportNodeBase(T userObject, FrameworkSupportNodeBase parentNode) {
        super(userObject);
        this.setChecked(false);
        this.myParentNode = parentNode;
        if (parentNode != null) {
            parentNode.add((MutableTreeNode)((Object)this));
        }
    }

    public T getUserObject() {
        return (T)((FrameworkOrGroup)super.getUserObject());
    }

    public static void sortByName(@Nullable List<FrameworkSupportNodeBase> nodes, final @Nullable Comparator<FrameworkSupportNodeBase> comparator) {
        if (nodes == null) {
            return;
        }
        Collections.sort(nodes, new Comparator<FrameworkSupportNodeBase>(){

            @Override
            public int compare(FrameworkSupportNodeBase o1, FrameworkSupportNodeBase o2) {
                int compare;
                if (comparator != null && (compare = comparator.compare(o1, o2)) != 0) {
                    return compare;
                }
                if (o1 instanceof FrameworkGroupNode && !(o2 instanceof FrameworkGroupNode)) {
                    return -1;
                }
                if (o2 instanceof FrameworkGroupNode && !(o1 instanceof FrameworkGroupNode)) {
                    return 1;
                }
                if (o1.getChildCount() < o2.getChildCount()) {
                    return 1;
                }
                if (o1.getChildCount() > o2.getChildCount()) {
                    return -1;
                }
                return o1.getTitle().compareToIgnoreCase(o2.getTitle());
            }
        });
        for (FrameworkSupportNodeBase node : nodes) {
            FrameworkSupportNodeBase.sortByName(node.children, null);
        }
    }

    @NotNull
    protected final String getTitle() {
        String string = this.getUserObject().getPresentableName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/FrameworkSupportNodeBase", "getTitle"));
        }
        return string;
    }

    @NotNull
    public final Icon getIcon() {
        Icon icon = this.getUserObject().getIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/FrameworkSupportNodeBase", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public final String getId() {
        String string = this.getUserObject().getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/FrameworkSupportNodeBase", "getId"));
        }
        return string;
    }

    @NotNull
    public List<FrameworkSupportNodeBase> getChildren() {
        Vector vector = this.children != null ? this.children : Collections.emptyList();
        if (vector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/FrameworkSupportNodeBase", "getChildren"));
        }
        return vector;
    }

    public FrameworkSupportNodeBase getParentNode() {
        return this.myParentNode;
    }
}

