/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import org.jetbrains.annotations.Nullable;

public class MoveCaretUpWithSelectionAction
extends EditorAction {
    public MoveCaretUpWithSelectionAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        public void doExecute(final Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (!editor.getCaretModel().supportsMultipleCarets()) {
                editor.getCaretModel().moveCaretRelatively(0, -1, true, editor.isColumnMode(), true);
                return;
            }
            if (editor.isColumnMode()) {
                EditorActionUtil.cloneOrRemoveCaret(editor, caret == null ? editor.getCaretModel().getPrimaryCaret() : caret, true);
            } else {
                CaretAction caretAction = new CaretAction(){

                    public void perform(Caret caret) {
                        caret.moveCaretRelatively(0, -1, true, caret == editor.getCaretModel().getPrimaryCaret());
                    }
                };
                if (caret == null) {
                    editor.getCaretModel().runForEachCaret(caretAction);
                } else {
                    caretAction.perform(caret);
                }
            }
        }
    }
}

