/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.NewChannelDialog;
import com.intellij.openapi.updateSettings.impl.NoUpdatesDialog;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.swing.event.HyperlinkEvent;
import org.apache.http.client.utils.URIBuilder;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UpdateChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.updateSettings.impl.UpdateChecker");
    public static final NotificationGroup NOTIFICATIONS = new NotificationGroup(IdeBundle.message((String)"update.notifications.group", (Object[])new Object[0]), NotificationDisplayType.STICKY_BALLOON, true);
    @NonNls
    private static final String INSTALLATION_UID = "installation.uid";
    @NonNls
    private static final String DISABLED_UPDATE = "disabled_update.txt";
    private static Set<String> ourDisabledToUpdatePlugins;
    private static final Map<String, String> ourAdditionalRequestOptions;
    private static final Map<String, PluginDownloader> ourUpdatedPlugins;
    private static boolean ourHasFailedPlugins;

    private UpdateChecker() {
    }

    private static String getUpdateUrl() {
        String url = System.getProperty("idea.updates.url");
        return url != null ? url : Holder.UPDATE_URL;
    }

    private static String getPatchesUrl() {
        String url = System.getProperty("idea.patches.url");
        return url != null ? url : Holder.PATCHES_URL;
    }

    public static ActionCallback updateAndShowResult() {
        final ActionCallback callback = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                UpdateChecker.doUpdateAndShowResult(null, true, false, UpdateSettings.getInstance(), null, callback);
            }
        });
        return callback;
    }

    public static void updateAndShowResult(@Nullable Project project, @Nullable UpdateSettings customSettings) {
        final UpdateSettings settings = customSettings != null ? customSettings : UpdateSettings.getInstance();
        final boolean fromSettings = customSettings != null;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, IdeBundle.message((String)"updates.checking.progress", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/UpdateChecker$2", "run"));
                }
                UpdateChecker.doUpdateAndShowResult(this.getProject(), !fromSettings, true, settings, indicator, null);
            }

            public boolean isConditionalModal() {
                return fromSettings;
            }

            public boolean shouldStartInBackground() {
                return !fromSettings;
            }
        });
    }

    private static void doUpdateAndShowResult(final @Nullable Project project, final boolean enableLink, final boolean manualCheck, final @NotNull UpdateSettings updateSettings, @Nullable ProgressIndicator indicator, final @Nullable ActionCallback callback) {
        HashSet<IdeaPluginDescriptor> incompatiblePlugins;
        Collection<PluginDownloader> updatedPlugins;
        if (updateSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateSettings", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "doUpdateAndShowResult"));
        }
        if (indicator != null) {
            indicator.setText(IdeBundle.message((String)"updates.checking.platform", (Object[])new Object[0]));
        }
        final CheckForUpdateResult result = UpdateChecker.checkPlatformUpdate(updateSettings);
        if (manualCheck && result.getState() == UpdateStrategy.State.LOADED) {
            UpdateSettings settings = UpdateSettings.getInstance();
            settings.saveLastCheckedInfo();
            settings.setKnownChannelIds(result.getAllChannelsIds());
        } else if (result.getState() == UpdateStrategy.State.CONNECTION_ERROR) {
            Exception e = result.getError();
            if (e != null) {
                LOG.debug((Throwable)e);
            }
            String cause = e != null ? e.getMessage() : "internal error";
            UpdateChecker.showErrorMessage(manualCheck, IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[]{cause}));
            return;
        }
        if (indicator != null) {
            indicator.setText(IdeBundle.message((String)"updates.checking.plugins", (Object[])new Object[0]));
        }
        if (UpdateChecker.newChannelReady(result.getChannelToPropose())) {
            updatedPlugins = null;
            incompatiblePlugins = null;
        } else {
            BuildInfo latestBuild;
            BuildNumber buildNumber = null;
            UpdateChannel updatedChannel = result.getUpdatedChannel();
            if (updatedChannel != null && (latestBuild = updatedChannel.getLatestBuild()) != null) {
                buildNumber = latestBuild.getNumber();
            }
            incompatiblePlugins = buildNumber != null ? new HashSet<IdeaPluginDescriptor>() : null;
            updatedPlugins = UpdateChecker.checkPluginsUpdate(manualCheck, updateSettings, indicator, incompatiblePlugins, buildNumber);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateChecker.showUpdateResult(project, result, updateSettings, updatedPlugins, incompatiblePlugins, enableLink, manualCheck);
                if (callback != null) {
                    callback.setDone();
                }
            }
        }, ModalityState.NON_MODAL);
    }

    @NotNull
    private static CheckForUpdateResult checkPlatformUpdate(@NotNull UpdateSettings settings) {
        UpdatesInfo info;
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "checkPlatformUpdate"));
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(UpdateChecker.getUpdateUrl());
            if (!"file".equals(uriBuilder.getScheme())) {
                UpdateChecker.prepareUpdateCheckArgs(uriBuilder);
            }
            String updateUrl = uriBuilder.build().toString();
            LogUtil.debug((Logger)LOG, (String)"load update xml (UPDATE_URL='%s')", (Object[])new Object[]{updateUrl});
            info = (UpdatesInfo)HttpRequests.request((String)updateUrl).forceHttps(settings.canUseSecureConnection()).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<UpdatesInfo>(){

                public UpdatesInfo process(@NotNull HttpRequests.Request request) throws IOException {
                    if (request == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/updateSettings/impl/UpdateChecker$4", "process"));
                    }
                    try {
                        return new UpdatesInfo(JDOMUtil.load((Reader)request.getReader()));
                    }
                    catch (JDOMException e) {
                        LOG.info((Throwable)e);
                        return null;
                    }
                }
            });
        }
        catch (URISyntaxException e) {
            CheckForUpdateResult checkForUpdateResult = new CheckForUpdateResult(UpdateStrategy.State.CONNECTION_ERROR, e);
            if (checkForUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "checkPlatformUpdate"));
            }
            return checkForUpdateResult;
        }
        catch (IOException e) {
            CheckForUpdateResult checkForUpdateResult = new CheckForUpdateResult(UpdateStrategy.State.CONNECTION_ERROR, e);
            if (checkForUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "checkPlatformUpdate"));
            }
            return checkForUpdateResult;
        }
        if (info == null) {
            CheckForUpdateResult checkForUpdateResult = new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED);
            if (checkForUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "checkPlatformUpdate"));
            }
            return checkForUpdateResult;
        }
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        int majorVersion = Integer.parseInt(appInfo.getMajorVersion());
        UpdateStrategy strategy = new UpdateStrategy(majorVersion, appInfo.getBuild(), info, settings);
        CheckForUpdateResult checkForUpdateResult = strategy.checkForUpdates();
        if (checkForUpdateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "checkPlatformUpdate"));
        }
        return checkForUpdateResult;
    }

    private static Collection<PluginDownloader> checkPluginsUpdate(boolean manualCheck, @NotNull UpdateSettings updateSettings, @Nullable ProgressIndicator indicator, @Nullable Collection<IdeaPluginDescriptor> incompatiblePlugins, @Nullable BuildNumber buildNumber) {
        if (updateSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateSettings", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "checkPluginsUpdate"));
        }
        THashMap updateable = ContainerUtil.newTroveMap();
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
            if (descriptor.isBundled()) continue;
            updateable.put(descriptor.getPluginId(), descriptor);
        }
        File onceInstalled = new File(PathManager.getConfigPath(), "installed.txt");
        if (onceInstalled.isFile()) {
            try {
                for (String line : FileUtil.loadLines((File)onceInstalled)) {
                    PluginId id = PluginId.getId((String)line.trim());
                    if (updateable.containsKey(id)) continue;
                    updateable.put(id, null);
                }
            }
            catch (IOException e) {
                LOG.error(onceInstalled.getPath(), (Throwable)e);
            }
            onceInstalled.deleteOnExit();
        }
        if (updateable.isEmpty()) {
            return null;
        }
        THashMap toUpdate = ContainerUtil.newTroveMap();
        List<String> hosts = RepositoryHelper.getPluginHosts();
        InstalledPluginsState state = InstalledPluginsState.getInstance();
        block6: for (String host : hosts) {
            try {
                boolean forceHttps = host == null && updateSettings.canUseSecureConnection();
                List<IdeaPluginDescriptor> list = RepositoryHelper.loadPlugins(host, buildNumber, forceHttps, indicator);
                for (IdeaPluginDescriptor descriptor : list) {
                    PluginId id = descriptor.getPluginId();
                    if (!updateable.containsKey(id)) continue;
                    updateable.remove(id);
                    state.onDescriptorDownload(descriptor);
                    PluginDownloader downloader = PluginDownloader.createDownloader(descriptor, host, buildNumber);
                    downloader.setForceHttps(forceHttps);
                    UpdateChecker.checkAndPrepareToInstall(downloader, state, (Map<PluginId, PluginDownloader>)toUpdate, incompatiblePlugins, indicator);
                    if (!updateable.isEmpty()) continue;
                    break block6;
                }
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                if (host != null) {
                    LOG.info("failed to load plugin descriptions from " + host + ": " + e.getMessage());
                    continue;
                }
                UpdateChecker.showErrorMessage(manualCheck, IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[]{e.getMessage()}));
            }
        }
        return toUpdate.isEmpty() ? null : toUpdate.values();
    }

    private static void checkAndPrepareToInstall(PluginDownloader downloader, InstalledPluginsState state, Map<PluginId, PluginDownloader> toUpdate, Collection<IdeaPluginDescriptor> incompatiblePlugins, @Nullable ProgressIndicator indicator) throws IOException {
        String pluginId = downloader.getPluginId();
        if (PluginManagerCore.getDisabledPlugins().contains(pluginId)) {
            return;
        }
        String pluginVersion = downloader.getPluginVersion();
        IdeaPluginDescriptor installedPlugin = PluginManager.getPlugin(PluginId.getId((String)pluginId));
        if (installedPlugin == null || pluginVersion == null || PluginDownloader.compareVersionsSkipBroken(installedPlugin, pluginVersion) > 0) {
            IdeaPluginDescriptor descriptor;
            PluginDownloader oldDownloader = ourUpdatedPlugins.get(pluginId);
            if (oldDownloader == null || StringUtil.compareVersionNumbers((String)pluginVersion, (String)oldDownloader.getPluginVersion()) > 0) {
                descriptor = downloader.getDescriptor();
                if (descriptor instanceof PluginNode && ((PluginNode)descriptor).isIncomplete()) {
                    if (downloader.prepareToInstall((ProgressIndicator)(indicator == null ? new EmptyProgressIndicator() : indicator))) {
                        descriptor = downloader.getDescriptor();
                    }
                    ourUpdatedPlugins.put(pluginId, downloader);
                }
            } else {
                downloader = oldDownloader;
                descriptor = oldDownloader.getDescriptor();
            }
            if (descriptor != null && !PluginManagerCore.isIncompatible(descriptor, downloader.getBuildNumber()) && !state.wasUpdated(descriptor.getPluginId())) {
                toUpdate.put(PluginId.getId((String)pluginId), downloader);
            }
        }
        if (incompatiblePlugins != null && installedPlugin != null && installedPlugin.isEnabled() && !toUpdate.containsKey(installedPlugin.getPluginId()) && PluginManagerCore.isIncompatible(installedPlugin, downloader.getBuildNumber())) {
            incompatiblePlugins.add(installedPlugin);
        }
    }

    private static void showErrorMessage(boolean showDialog, final String message) {
        LOG.info(message);
        if (showDialog) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((String)message, (String)IdeBundle.message((String)"updates.error.connection.title", (Object[])new Object[0]));
                }
            });
        }
    }

    @Contract(value="null -> false")
    private static boolean newChannelReady(@Nullable UpdateChannel channelToPropose) {
        return channelToPropose != null && channelToPropose.getLatestBuild() != null;
    }

    private static void showUpdateResult(@Nullable Project project, final CheckForUpdateResult checkForUpdateResult, final UpdateSettings updateSettings, final Collection<PluginDownloader> updatedPlugins, final Collection<IdeaPluginDescriptor> incompatiblePlugins, final boolean enableLink, boolean alwaysShowResults) {
        final UpdateChannel channelToPropose = checkForUpdateResult.getChannelToPropose();
        final UpdateChannel updatedChannel = checkForUpdateResult.getUpdatedChannel();
        if (updatedChannel != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    new UpdateInfoDialog(updatedChannel, enableLink, updateSettings.canUseSecureConnection(), updatedPlugins, incompatiblePlugins).show();
                }
            };
            if (alwaysShowResults) {
                runnable.run();
            } else {
                String message = IdeBundle.message((String)"updates.ready.message", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                UpdateChecker.showNotification(project, message, false, runnable);
            }
        } else if (UpdateChecker.newChannelReady(channelToPropose)) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    NewChannelDialog dialog = new NewChannelDialog(channelToPropose);
                    dialog.show();
                    if (dialog.getExitCode() == 1 && checkForUpdateResult.getState() == UpdateStrategy.State.LOADED && !updateSettings.getKnownChannelsIds().contains(channelToPropose.getId())) {
                        ArrayList<String> newIds = new ArrayList<String>(updateSettings.getKnownChannelsIds());
                        newIds.add(channelToPropose.getId());
                        updateSettings.setKnownChannelIds(newIds);
                    }
                }
            };
            if (alwaysShowResults) {
                runnable.run();
            } else {
                String message = IdeBundle.message((String)"updates.new.version.available", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                UpdateChecker.showNotification(project, message, false, runnable);
            }
        } else if (updatedPlugins != null && !updatedPlugins.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    new PluginUpdateInfoDialog(updatedPlugins, enableLink).show();
                }
            };
            if (alwaysShowResults) {
                runnable.run();
            } else {
                String plugins = StringUtil.join(updatedPlugins, (Function)new Function<PluginDownloader, String>(){

                    public String fun(PluginDownloader downloader) {
                        return downloader.getPluginName();
                    }
                }, (String)", ");
                String message = IdeBundle.message((String)"updates.plugins.ready.message", (Object[])new Object[]{updatedPlugins.size(), plugins});
                UpdateChecker.showNotification(project, message, false, runnable);
            }
        } else if (alwaysShowResults) {
            new NoUpdatesDialog(enableLink).show();
        }
    }

    private static void showNotification(@Nullable Project project, String message, boolean error, final @Nullable Runnable runnable) {
        NotificationListener listener = null;
        if (runnable != null) {
            listener = new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/updateSettings/impl/UpdateChecker$10", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/updateSettings/impl/UpdateChecker$10", "hyperlinkUpdate"));
                    }
                    notification.expire();
                    runnable.run();
                }
            };
        }
        String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
        NotificationType type = error ? NotificationType.ERROR : NotificationType.INFORMATION;
        NOTIFICATIONS.createNotification(title, XmlStringUtil.wrapInHtml((CharSequence)message), type, listener).notify(project);
    }

    public static void addUpdateRequestParameter(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "addUpdateRequestParameter"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "addUpdateRequestParameter"));
        }
        ourAdditionalRequestOptions.put(name, value);
    }

    private static void prepareUpdateCheckArgs(URIBuilder uriBuilder) {
        UpdateChecker.addUpdateRequestParameter("build", ApplicationInfo.getInstance().getBuild().asString());
        UpdateChecker.addUpdateRequestParameter("uid", UpdateChecker.getInstallationUID(PropertiesComponent.getInstance()));
        UpdateChecker.addUpdateRequestParameter("os", SystemInfo.OS_NAME + ' ' + SystemInfo.OS_VERSION);
        if (ApplicationInfoEx.getInstanceEx().isEAP()) {
            UpdateChecker.addUpdateRequestParameter("eap", "");
        }
        Iterator<String> i$ = ourAdditionalRequestOptions.keySet().iterator();
        while (i$.hasNext()) {
            String name;
            String value = ourAdditionalRequestOptions.get(name = i$.next());
            uriBuilder.addParameter(name, StringUtil.isEmpty((String)value) ? null : value);
        }
    }

    public static String getInstallationUID(PropertiesComponent propertiesComponent) {
        String uid;
        if (SystemInfo.isWindows && (uid = UpdateChecker.getInstallationUIDOnWindows(propertiesComponent)) != null) {
            return uid;
        }
        uid = propertiesComponent.getValue(INSTALLATION_UID);
        if (uid == null) {
            uid = UpdateChecker.generateUUID();
            propertiesComponent.setValue(INSTALLATION_UID, uid);
        }
        return uid;
    }

    @Nullable
    private static String getInstallationUIDOnWindows(PropertiesComponent propertiesComponent) {
        File jetBrainsDir;
        String appdata = System.getenv("APPDATA");
        if (appdata != null && ((jetBrainsDir = new File(appdata, "JetBrains")).exists() || jetBrainsDir.mkdirs())) {
            File permanentIdFile = new File(jetBrainsDir, "PermanentUserId");
            try {
                if (permanentIdFile.exists()) {
                    return FileUtil.loadFile((File)permanentIdFile).trim();
                }
                String uuid = propertiesComponent.getValue(INSTALLATION_UID);
                if (uuid == null) {
                    uuid = UpdateChecker.generateUUID();
                }
                FileUtil.writeToFile((File)permanentIdFile, (String)uuid);
                return uuid;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    private static String generateUUID() {
        try {
            return UUID.randomUUID().toString();
        }
        catch (Exception ignored) {
        }
        catch (InternalError internalError) {
            // empty catch block
        }
        return "";
    }

    public static void installPlatformUpdate(final PatchInfo patch, final BuildNumber toBuild, final boolean forceHttps) throws IOException {
        ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Void, IOException>(){

            public Void compute() throws IOException {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                UpdateChecker.downloadAndInstallPatch(patch, toBuild, forceHttps, indicator);
                return null;
            }
        }, IdeBundle.message((String)"update.downloading.patch.progress.title", (Object[])new Object[0]), true, null);
    }

    private static void downloadAndInstallPatch(PatchInfo patch, BuildNumber toBuild, boolean forceHttps, final ProgressIndicator indicator) throws IOException {
        String productCode = ApplicationInfo.getInstance().getBuild().getProductCode();
        String fromBuildNumber = patch.getFromBuild().asStringWithoutProductCode();
        String toBuildNumber = toBuild.asStringWithoutProductCode();
        String bundledJdk = "";
        String jdkMacRedist = System.getProperty("idea.java.redist");
        if (jdkMacRedist != null && jdkMacRedist.lastIndexOf("jdk-bundled") >= 0) {
            bundledJdk = "jdk-bundled".equals(jdkMacRedist) ? "-jdk-bundled" : "-custom-jdk-bundled";
        }
        String osSuffix = "-" + patch.getOSSuffix();
        String fileName = productCode + "-" + fromBuildNumber + "-" + toBuildNumber + "-patch" + bundledJdk + osSuffix + ".jar";
        String url = new URL(new URL(UpdateChecker.getPatchesUrl()), fileName).toString();
        File tempFile = (File)HttpRequests.request((String)url).gzip(false).forceHttps(forceHttps).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<File>(){

            public File process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/updateSettings/impl/UpdateChecker$12", "process"));
                }
                return request.saveToFile(FileUtil.createTempFile((String)"ij.platform.", (String)".patch", (boolean)true), indicator);
            }
        });
        String patchFileName = ("jetbrains.patch.jar." + PlatformUtils.getPlatformPrefix()).toLowerCase(Locale.ENGLISH);
        File patchFile = new File(FileUtil.getTempDirectory(), patchFileName);
        FileUtil.copy((File)tempFile, (File)patchFile);
        FileUtil.delete((File)tempFile);
    }

    public static boolean installPluginUpdates(@NotNull Collection<PluginDownloader> downloaders, @NotNull ProgressIndicator indicator) {
        if (downloaders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloaders", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "installPluginUpdates"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "installPluginUpdates"));
        }
        boolean installed = false;
        Set<String> disabledToUpdate = UpdateChecker.getDisabledToUpdatePlugins();
        for (PluginDownloader downloader : downloaders) {
            if (disabledToUpdate.contains(downloader.getPluginId())) continue;
            try {
                IdeaPluginDescriptor descriptor;
                if (!downloader.prepareToInstall(indicator) || (descriptor = downloader.getDescriptor()) == null) continue;
                downloader.install();
                installed = true;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return installed;
    }

    public static Set<String> getDisabledToUpdatePlugins() {
        if (ourDisabledToUpdatePlugins == null) {
            ourDisabledToUpdatePlugins = new TreeSet<String>();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    File file = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
                    if (file.isFile()) {
                        String[] ids;
                        for (String id : ids = FileUtil.loadFile((File)file).split("[\\s]")) {
                            if (id == null || id.trim().length() <= 0) continue;
                            ourDisabledToUpdatePlugins.add(id.trim());
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return ourDisabledToUpdatePlugins;
    }

    public static void saveDisabledToUpdatePlugins() {
        File plugins = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
        try {
            PluginManagerCore.savePluginsList(UpdateChecker.getDisabledToUpdatePlugins(), false, plugins);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void checkForUpdate(IdeaLoggingEvent event) {
        Throwable throwable;
        IdeaPluginDescriptor pluginDescriptor;
        if (!ourHasFailedPlugins && UpdateSettings.getInstance().isCheckNeeded() && (pluginDescriptor = PluginManager.getPlugin(IdeErrorsDialog.findPluginId(throwable = event.getThrowable()))) != null && !pluginDescriptor.isBundled()) {
            ourHasFailedPlugins = true;
            UpdateChecker.updateAndShowResult();
        }
    }

    static {
        ourAdditionalRequestOptions = ContainerUtil.newHashMap();
        ourUpdatedPlugins = ContainerUtil.newHashMap();
        ourHasFailedPlugins = false;
    }

    private static class Holder {
        private static final String UPDATE_URL = ApplicationInfoEx.getInstanceEx().getUpdateUrls().getCheckingUrl();
        private static final String PATCHES_URL = ApplicationInfoEx.getInstanceEx().getUpdateUrls().getPatchesUrl();

        private Holder() {
        }
    }
}

