/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.IntSLRUCache;
import com.intellij.util.containers.IntObjectLinkedMap;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.text.ByteArrayCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileNameCache {
    private static final PersistentStringEnumerator ourNames = FSRecords.getNames();
    private static final IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>>[] ourNameCache = new IntSLRUCache[16];

    public static int storeName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "storeName"));
        }
        int idx = FSRecords.getNameId(name);
        FileNameCache.cacheData(name, idx, FileNameCache.calcStripeIdFromNameId(idx));
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static IntObjectLinkedMap.MapEntry<CharSequence> cacheData(String name, int id, int stripe) {
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> cache;
        if (name == null) {
            ourNames.markCorrupted();
            throw new RuntimeException("VFS name enumerator corrupted");
        }
        CharSequence rawName = FileNameCache.convertToBytesIfAsciiString(name);
        IntObjectLinkedMap.MapEntry<CharSequence> entry = new IntObjectLinkedMap.MapEntry<CharSequence>(id, rawName);
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> intSLRUCache = cache = ourNameCache[stripe];
        // MONITORENTER : intSLRUCache
        IntObjectLinkedMap.MapEntry<CharSequence> mapEntry = cache.cacheEntry(entry);
        // MONITOREXIT : intSLRUCache
        if (mapEntry != null) return mapEntry;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "cacheData"));
    }

    private static int calcStripeIdFromNameId(int id) {
        int h = id;
        h -= h << 6;
        h ^= h >> 17;
        h -= h << 9;
        h ^= h << 4;
        h -= h << 3;
        h ^= h << 10;
        h ^= h >> 15;
        return h % ourNameCache.length;
    }

    @NotNull
    private static CharSequence convertToBytesIfAsciiString(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "convertToBytesIfAsciiString"));
        }
        int length = name.length();
        if (length == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "convertToBytesIfAsciiString"));
            }
            return "";
        }
        if (!IOUtil.isAscii((String)name)) {
            String string = new String(name);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "convertToBytesIfAsciiString"));
            }
            return string;
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)name.charAt(i);
        }
        ByteArrayCharSequence byteArrayCharSequence = new ByteArrayCharSequence(bytes);
        if (byteArrayCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "convertToBytesIfAsciiString"));
        }
        return byteArrayCharSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static IntObjectLinkedMap.MapEntry<CharSequence> getEntry(int id) {
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> cache;
        assert (id > 0);
        int stripe = FileNameCache.calcStripeIdFromNameId(id);
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> intSLRUCache = cache = ourNameCache[stripe];
        synchronized (intSLRUCache) {
            IntObjectLinkedMap.MapEntry<CharSequence> entry = cache.getCachedEntry(id);
            if (entry != null) {
                IntObjectLinkedMap.MapEntry<CharSequence> mapEntry = entry;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                if (mapEntry == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "getEntry"));
                }
                return mapEntry;
            }
        }
        IntObjectLinkedMap.MapEntry<CharSequence> mapEntry = FileNameCache.cacheData(FSRecords.getNameByNameId(id), id, stripe);
        if (mapEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "getEntry"));
        }
        return mapEntry;
    }

    @NotNull
    public static CharSequence getVFileName(int nameId) {
        CharSequence charSequence = (CharSequence)FileNameCache.getEntry((int)nameId).value;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "getVFileName"));
        }
        return charSequence;
    }

    @NotNull
    static char[] appendPathOnFileSystem(int nameId, @Nullable VirtualFileSystemEntry parent, int accumulatedPathLength, @NotNull int[] positionRef) {
        char[] chars;
        boolean appendSlash;
        if (positionRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "positionRef", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "appendPathOnFileSystem"));
        }
        IntObjectLinkedMap.MapEntry<CharSequence> entry = FileNameCache.getEntry(nameId);
        CharSequence o = (CharSequence)entry.value;
        int nameLength = o.length();
        boolean bl = appendSlash = SystemInfo.isWindows && parent == null && nameLength == 2 && o.charAt(1) == ':';
        if (parent != null) {
            chars = parent.appendPathOnFileSystem(accumulatedPathLength + 1 + nameLength, positionRef);
            if (positionRef[0] > 0 && chars[positionRef[0] - 1] != '/') {
                int n = positionRef[0];
                positionRef[0] = n + 1;
                chars[n] = 47;
            }
        } else {
            int rootPathLength = accumulatedPathLength + nameLength;
            if (appendSlash) {
                ++rootPathLength;
            }
            chars = new char[rootPathLength];
        }
        positionRef[0] = VirtualFileSystemEntry.copyString(chars, positionRef[0], o);
        if (appendSlash) {
            int n = positionRef[0];
            positionRef[0] = n + 1;
            chars[n] = 47;
        }
        if (chars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "appendPathOnFileSystem"));
        }
        return chars;
    }

    static {
        int protectedSize = 40000 / ourNameCache.length;
        int probationalSize = 20000 / ourNameCache.length;
        for (int i = 0; i < ourNameCache.length; ++i) {
            FileNameCache.ourNameCache[i] = new IntSLRUCache(protectedSize, probationalSize);
        }
    }
}

