/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class ConstructorReferencesSearchHelper {
    private final PsiManager myManager;

    public ConstructorReferencesSearchHelper(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "<init>"));
        }
        this.myManager = manager;
    }

    public boolean processConstructorReferences(final @NotNull Processor<PsiReference> processor, final @NotNull PsiMethod constructor, final @NotNull PsiClass containingClass, final @NotNull SearchScope searchScope, boolean ignoreAccessScope, final boolean isStrictSignatureSearch, @NotNull SearchRequestCollector collector) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        final boolean[] constructorCanBeCalledImplicitly = new boolean[1];
        final boolean[] isEnum = new boolean[1];
        final boolean[] isUnder18 = new boolean[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                constructorCanBeCalledImplicitly[0] = constructor.getParameterList().getParametersCount() == 0;
                isEnum[0] = containingClass.isEnum();
                isUnder18[0] = PsiUtil.getLanguageLevel((PsiElement)containingClass).isAtLeast(LanguageLevel.JDK_1_8);
            }
        });
        if (isEnum[0] && !ConstructorReferencesSearchHelper.processEnumReferences(processor, constructor, containingClass)) {
            return false;
        }
        PairProcessor<PsiReference, SearchRequestCollector> processor1 = new PairProcessor<PsiReference, SearchRequestCollector>(){

            public boolean process(PsiReference reference, SearchRequestCollector collector) {
                PsiMethod constructor1;
                PsiElement parent = reference.getElement().getParent();
                if (parent instanceof PsiAnonymousClass) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiNewExpression && (constructor1 = ((PsiNewExpression)parent).resolveConstructor()) != null && (isStrictSignatureSearch ? ConstructorReferencesSearchHelper.this.myManager.areElementsEquivalent((PsiElement)constructor, (PsiElement)constructor1) : ConstructorReferencesSearchHelper.this.myManager.areElementsEquivalent((PsiElement)containingClass, (PsiElement)constructor1.getContainingClass()))) {
                    return processor.process((Object)reference);
                }
                return true;
            }
        };
        ReferencesSearch.searchOptimized((PsiElement)containingClass, (SearchScope)searchScope, (boolean)ignoreAccessScope, (SearchRequestCollector)collector, (boolean)true, (PairProcessor)processor1);
        if (isUnder18[0] && !ConstructorReferencesSearchHelper.process18MethodPointers(processor, constructor, containingClass, searchScope)) {
            return false;
        }
        if (!((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return ConstructorReferencesSearchHelper.this.processSuperOrThis(containingClass, constructor, constructorCanBeCalledImplicitly[0], searchScope, isStrictSignatureSearch, "this", (Processor<PsiReference>)processor);
            }
        })).booleanValue()) {
            return false;
        }
        Processor<PsiClass> processor2 = new Processor<PsiClass>(){

            public boolean process(PsiClass inheritor) {
                PsiElement navigationElement = inheritor.getNavigationElement();
                if (navigationElement instanceof PsiClass) {
                    return ConstructorReferencesSearchHelper.this.processSuperOrThis((PsiClass)navigationElement, constructor, constructorCanBeCalledImplicitly[0], searchScope, isStrictSignatureSearch, "super", (Processor<PsiReference>)processor);
                }
                return true;
            }
        };
        return ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)searchScope, (boolean)false).forEach((Processor)processor2);
    }

    private static boolean processEnumReferences(final @NotNull Processor<PsiReference> processor, final @NotNull PsiMethod constructor, final @NotNull PsiClass aClass) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processEnumReferences"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processEnumReferences"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processEnumReferences"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                for (PsiField field : aClass.getFields()) {
                    PsiReference reference;
                    if (!(field instanceof PsiEnumConstant) || (reference = field.getReference()) == null || !reference.isReferenceTo((PsiElement)constructor) || processor.process((Object)reference)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private static boolean process18MethodPointers(final @NotNull Processor<PsiReference> processor, final @NotNull PsiMethod constructor, @NotNull PsiClass aClass, SearchScope searchScope) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "process18MethodPointers"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "process18MethodPointers"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "process18MethodPointers"));
        }
        return ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope).forEach((Processor)new ReadActionProcessor<PsiReference>(){

            public boolean processInReadAction(PsiReference reference) {
                PsiElement parent;
                PsiElement element = reference.getElement();
                return element == null || !((parent = element.getParent()) instanceof PsiMethodReferenceExpression) || !(((PsiMethodReferenceExpression)parent).getReferenceNameElement() instanceof PsiKeyword) || !((PsiMethodReferenceExpression)parent).isReferenceTo((PsiElement)constructor) || processor.process((Object)((PsiReference)parent));
            }
        });
    }

    private boolean processSuperOrThis(@NotNull PsiClass inheritor, @NotNull PsiMethod constructor, boolean constructorCanBeCalledImplicitly, @NotNull SearchScope searchScope, boolean isStrictSignatureSearch, @NotNull String superOrThisKeyword, @NotNull Processor<PsiReference> processor) {
        if (inheritor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (superOrThisKeyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superOrThisKeyword", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        PsiMethod[] constructors = inheritor.getConstructors();
        if (constructors.length == 0 && constructorCanBeCalledImplicitly && !this.processImplicitConstructorCall((PsiMember)inheritor, processor, constructor, inheritor)) {
            return false;
        }
        for (PsiMethod method : constructors) {
            PsiReferenceExpression refExpr;
            PsiExpression expr;
            PsiStatement statement;
            PsiCodeBlock body = method.getBody();
            if (body == null || method == constructor && isStrictSignatureSearch) continue;
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 0 && (statement = statements[0]) instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiMethodCallExpression && PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)(refExpr = ((PsiMethodCallExpression)expr).getMethodExpression())) && refExpr.textMatches((CharSequence)superOrThisKeyword)) {
                boolean match;
                PsiElement referencedElement = refExpr.resolve();
                if (!(referencedElement instanceof PsiMethod)) continue;
                PsiMethod constructor1 = (PsiMethod)referencedElement;
                boolean bl = match = isStrictSignatureSearch ? this.myManager.areElementsEquivalent((PsiElement)constructor1, (PsiElement)constructor) : this.myManager.areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)constructor1.getContainingClass());
                if (!match || processor.process((Object)refExpr)) continue;
                return false;
            }
            if (!constructorCanBeCalledImplicitly || this.processImplicitConstructorCall((PsiMember)method, processor, constructor, inheritor)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitConstructorCall(final @NotNull PsiMember usage, @NotNull Processor<PsiReference> processor, final @NotNull PsiMethod constructor, final @NotNull PsiClass containingClass) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (containingClass instanceof PsiAnonymousClass) {
            return true;
        }
        boolean same = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return ConstructorReferencesSearchHelper.this.myManager.areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)containingClass.getSuperClass());
            }
        });
        if (!same) {
            return true;
        }
        return processor.process((Object)new LightMemberReference(this.myManager, usage, PsiSubstitutor.EMPTY){

            @Override
            public PsiElement getElement() {
                return usage;
            }

            @Override
            public TextRange getRangeInElement() {
                if (usage instanceof PsiClass) {
                    PsiIdentifier identifier = ((PsiClass)usage).getNameIdentifier();
                    if (identifier != null) {
                        return TextRange.from((int)identifier.getStartOffsetInParent(), (int)identifier.getTextLength());
                    }
                } else {
                    PsiIdentifier identifier;
                    if (usage instanceof PsiField) {
                        PsiIdentifier identifier2 = ((PsiField)usage).getNameIdentifier();
                        return TextRange.from((int)identifier2.getStartOffsetInParent(), (int)identifier2.getTextLength());
                    }
                    if (usage instanceof PsiMethod && (identifier = ((PsiMethod)usage).getNameIdentifier()) != null) {
                        return TextRange.from((int)identifier.getStartOffsetInParent(), (int)identifier.getTextLength());
                    }
                }
                return super.getRangeInElement();
            }
        });
    }
}

