/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureViewDescriptor;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSignatureProcessor
extends ChangeSignatureProcessorBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.ChangeSignatureProcessor");

    public ChangeSignatureProcessor(Project project, PsiMethod method, boolean generateDelegate, @PsiModifier.ModifierConstant String newVisibility, String newName, PsiType newType, @NotNull ParameterInfoImpl[] parameterInfo) {
        if (parameterInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterInfo", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessor", "<init>"));
        }
        this(project, method, generateDelegate, newVisibility, newName, newType != null ? CanonicalTypes.createTypeWrapper(newType) : null, parameterInfo, null, null, null);
    }

    public ChangeSignatureProcessor(Project project, PsiMethod method, boolean generateDelegate, @PsiModifier.ModifierConstant String newVisibility, String newName, PsiType newType, ParameterInfoImpl[] parameterInfo, ThrownExceptionInfo[] exceptionInfos) {
        this(project, method, generateDelegate, newVisibility, newName, newType != null ? CanonicalTypes.createTypeWrapper(newType) : null, parameterInfo, exceptionInfos, null, null);
    }

    public ChangeSignatureProcessor(Project project, PsiMethod method, boolean generateDelegate, @PsiModifier.ModifierConstant String newVisibility, String newName, CanonicalTypes.Type newType, @NotNull ParameterInfoImpl[] parameterInfo, ThrownExceptionInfo[] thrownExceptions, Set<PsiMethod> propagateParametersMethods, Set<PsiMethod> propagateExceptionsMethods) {
        if (parameterInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterInfo", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessor", "<init>"));
        }
        this(project, ChangeSignatureProcessor.generateChangeInfo(method, generateDelegate, newVisibility, newName, newType, parameterInfo, thrownExceptions, propagateParametersMethods, propagateExceptionsMethods));
    }

    public ChangeSignatureProcessor(Project project, JavaChangeInfo changeInfo) {
        super(project, changeInfo);
        LOG.assertTrue(this.myChangeInfo.getMethod().isValid());
    }

    private static JavaChangeInfo generateChangeInfo(PsiMethod method, boolean generateDelegate, @PsiModifier.ModifierConstant String newVisibility, String newName, CanonicalTypes.Type newType, @NotNull ParameterInfoImpl[] parameterInfo, ThrownExceptionInfo[] thrownExceptions, Set<PsiMethod> propagateParametersMethods, Set<PsiMethod> propagateExceptionsMethods) {
        if (parameterInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterInfo", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessor", "generateChangeInfo"));
        }
        LOG.assertTrue(method.isValid());
        if (propagateParametersMethods == null) {
            propagateParametersMethods = ContainerUtil.newHashSet();
        }
        if (propagateExceptionsMethods == null) {
            propagateExceptionsMethods = ContainerUtil.newHashSet();
        }
        if (newVisibility == null) {
            newVisibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
        }
        return new JavaChangeInfoImpl(newVisibility, method, newName, newType, parameterInfo, thrownExceptions, generateDelegate, propagateParametersMethods, propagateExceptionsMethods);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        ChangeSignatureViewDescriptor changeSignatureViewDescriptor = new ChangeSignatureViewDescriptor(this.getChangeInfo().getMethod());
        if (changeSignatureViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessor", "createUsageViewDescriptor"));
        }
        return changeSignatureViewDescriptor;
    }

    @Override
    public JavaChangeInfoImpl getChangeInfo() {
        return (JavaChangeInfoImpl)super.getChangeInfo();
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        boolean condition = elements.length == 1 && elements[0] instanceof PsiMethod;
        LOG.assertTrue(condition);
        this.getChangeInfo().updateMethod((PsiMethod)elements[0]);
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        for (ChangeSignatureUsageProcessor processor : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            if (processor.setupDefaultValues(this.myChangeInfo, refUsages, this.myProject)) continue;
            return false;
        }
        MultiMap conflictDescriptions = new MultiMap();
        for (ChangeSignatureUsageProcessor usageProcessor : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            MultiMap conflicts = usageProcessor.findConflicts(this.myChangeInfo, refUsages);
            for (PsiElement key : conflicts.keySet()) {
                Collection collection = conflictDescriptions.get((Object)key);
                if (collection.size() == 0) {
                    collection = new HashSet();
                }
                collection.addAll(conflicts.get((Object)key));
                conflictDescriptions.put((Object)key, collection);
            }
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        RenameUtil.addConflictDescriptions(usagesIn, (MultiMap<PsiElement, String>)conflictDescriptions);
        HashSet usagesSet = new HashSet(Arrays.asList(usagesIn));
        RenameUtil.removeConflictUsages((Set<UsageInfo>)usagesSet);
        if (!conflictDescriptions.isEmpty()) {
            ConflictsDialog dialog;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflictDescriptions.values());
            }
            if (this.myPrepareSuccessfulSwingThreadCallback != null && !(dialog = this.prepareConflictsDialog((MultiMap<PsiElement, String>)conflictDescriptions, usagesIn)).showAndGet()) {
                if (dialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        if (this.myChangeInfo.isReturnTypeChanged()) {
            this.askToRemoveCovariantOverriders((Set<UsageInfo>)usagesSet);
        }
        refUsages.set((Object)usagesSet.toArray(new UsageInfo[usagesSet.size()]));
        this.prepareSuccessful();
        return true;
    }

    private void askToRemoveCovariantOverriders(Set<UsageInfo> usages) {
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)this.myChangeInfo.getMethod())) {
            ArrayList<UsageInfo> covariantOverriderInfos = new ArrayList<UsageInfo>();
            for (UsageInfo usageInfo : usages) {
                PsiType type;
                if (!(usageInfo instanceof OverriderUsageInfo)) continue;
                OverriderUsageInfo info = (OverriderUsageInfo)usageInfo;
                PsiMethod overrider = (PsiMethod)ObjectUtils.assertNotNull((Object)info.getOverridingMethod());
                PsiMethod baseMethod = info.getBaseMethod();
                PsiSubstitutor substitutor = ChangeSignatureProcessor.calculateSubstitutor(overrider, baseMethod);
                try {
                    type = substitutor.substitute(this.getChangeInfo().newReturnType.getType(this.myChangeInfo.getMethod(), this.myManager));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    return;
                }
                PsiType overriderType = overrider.getReturnType();
                if (overriderType == null || !type.isAssignableFrom(overriderType)) continue;
                covariantOverriderInfos.add(usageInfo);
            }
            this.preprocessCovariantOverriders(covariantOverriderInfos);
            if (!(covariantOverriderInfos.isEmpty() || !ApplicationManager.getApplication().isUnitTestMode() && this.isProcessCovariantOverriders())) {
                for (UsageInfo usageInfo : covariantOverriderInfos) {
                    usages.remove(usageInfo);
                }
            }
        }
    }

    protected void preprocessCovariantOverriders(List<UsageInfo> covariantOverriderInfos) {
    }

    protected boolean isProcessCovariantOverriders() {
        String message = RefactoringBundle.message((String)"do.you.want.to.process.overriding.methods.with.covariant.return.type");
        return Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)ChangeSignatureHandler.REFACTORING_NAME, (Icon)Messages.getQuestionIcon()) == 0;
    }

    public static void makeEmptyBody(PsiElementFactory factory, PsiMethod delegate) throws IncorrectOperationException {
        PsiCodeBlock body = delegate.getBody();
        if (body != null) {
            body.replace((PsiElement)factory.createCodeBlock());
        } else {
            delegate.add((PsiElement)factory.createCodeBlock());
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)delegate, (String)"abstract", (boolean)false);
    }

    @Nullable
    public static PsiCallExpression addDelegatingCallTemplate(PsiMethod delegate, String newName) throws IncorrectOperationException {
        PsiCallExpression callExpression;
        Project project = delegate.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiCodeBlock body = delegate.getBody();
        assert (body != null);
        if (delegate.isConstructor()) {
            PsiStatement callStatement = factory.createStatementFromText("this();", null);
            callStatement = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)callStatement);
            callStatement = body.add((PsiElement)callStatement);
            callExpression = (PsiCallExpression)((PsiExpressionStatement)callStatement).getExpression();
        } else if (PsiType.VOID.equals((Object)delegate.getReturnType())) {
            PsiStatement callStatement = factory.createStatementFromText(newName + "();", null);
            callStatement = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)callStatement);
            callStatement = body.add((PsiElement)callStatement);
            callExpression = (PsiCallExpression)((PsiExpressionStatement)callStatement).getExpression();
        } else {
            PsiStatement callStatement = factory.createStatementFromText("return " + newName + "();", null);
            callStatement = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)callStatement);
            callStatement = body.add((PsiElement)callStatement);
            callExpression = (PsiCallExpression)((PsiReturnStatement)callStatement).getReturnValue();
        }
        return callExpression;
    }

    public static PsiSubstitutor calculateSubstitutor(PsiMethod derivedMethod, PsiMethod baseMethod) {
        PsiSubstitutor substitutor;
        if (derivedMethod.getManager().areElementsEquivalent((PsiElement)derivedMethod, (PsiElement)baseMethod)) {
            substitutor = PsiSubstitutor.EMPTY;
        } else {
            PsiClass baseClass = baseMethod.getContainingClass();
            PsiClass derivedClass = derivedMethod.getContainingClass();
            if (baseClass != null && derivedClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)derivedClass, (PsiClass)baseClass, (boolean)true)) {
                PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)derivedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                MethodSignature superMethodSignature = baseMethod.getSignature(superClassSubstitutor);
                MethodSignature methodSignature = derivedMethod.getSignature(PsiSubstitutor.EMPTY);
                PsiSubstitutor superMethodSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superMethodSignature);
                substitutor = superMethodSubstitutor != null ? superMethodSubstitutor : superClassSubstitutor;
            } else {
                substitutor = PsiSubstitutor.EMPTY;
            }
        }
        return substitutor;
    }
}

