/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.util.List;
import org.codehaus.groovy.classgen.Verifier;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.project.ProjectScript;
import org.gradle.api.plugins.PluginAware;
import org.gradle.configuration.ImportsReader;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.BasicScript;
import org.gradle.groovy.scripts.ScriptAware;
import org.gradle.groovy.scripts.ScriptCompiler;
import org.gradle.groovy.scripts.ScriptCompilerFactory;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.BuildScriptTransformer;
import org.gradle.groovy.scripts.internal.PluginsAndBuildscriptTransformer;
import org.gradle.groovy.scripts.internal.StatementExtractingScriptTransformer;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.model.dsl.internal.transform.ClosureCreationInterceptingVerifier;
import org.gradle.plugin.use.internal.PluginDependenciesService;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.internal.PluginRequestApplicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptPluginFactory
implements ScriptPluginFactory {
    private final ScriptCompilerFactory scriptCompilerFactory;
    private final ImportsReader importsReader;
    private final Factory<LoggingManagerInternal> loggingManagerFactory;
    private final Instantiator instantiator;
    private final ScriptHandlerFactory scriptHandlerFactory;
    private final PluginRequestApplicator pluginRequestApplicator;
    private final FileLookup fileLookup;
    private final DocumentationRegistry documentationRegistry;

    public DefaultScriptPluginFactory(ScriptCompilerFactory scriptCompilerFactory, ImportsReader importsReader, Factory<LoggingManagerInternal> loggingManagerFactory, Instantiator instantiator, ScriptHandlerFactory scriptHandlerFactory, PluginRequestApplicator pluginRequestApplicator, FileLookup fileLookup, DocumentationRegistry documentationRegistry) {
        this.scriptCompilerFactory = scriptCompilerFactory;
        this.importsReader = importsReader;
        this.loggingManagerFactory = loggingManagerFactory;
        this.instantiator = instantiator;
        this.scriptHandlerFactory = scriptHandlerFactory;
        this.pluginRequestApplicator = pluginRequestApplicator;
        this.fileLookup = fileLookup;
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public ScriptPlugin create(ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope, String classpathClosureName, Class<? extends BasicScript> scriptClass, boolean ownerScript) {
        return new ScriptPluginImpl(scriptSource, scriptHandler, targetScope, baseScope, classpathClosureName, scriptClass, ownerScript);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScriptPluginImpl
    implements ScriptPlugin {
        private final ScriptSource scriptSource;
        private final ClassLoaderScope targetScope;
        private final ClassLoaderScope baseScope;
        private final String classpathClosureName;
        private final Class<? extends BasicScript> scriptType;
        private final ScriptHandler scriptHandler;
        private final boolean ownerScript;

        public ScriptPluginImpl(ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope, String classpathClosureName, Class<? extends BasicScript> scriptType, boolean ownerScript) {
            this.scriptSource = scriptSource;
            this.targetScope = targetScope;
            this.baseScope = baseScope;
            this.classpathClosureName = classpathClosureName;
            this.scriptHandler = scriptHandler;
            this.scriptType = scriptType;
            this.ownerScript = ownerScript;
        }

        @Override
        public ScriptSource getSource() {
            return this.scriptSource;
        }

        @Override
        public void apply(Object target) {
            DefaultServiceRegistry services = new DefaultServiceRegistry();
            services.add(ScriptPluginFactory.class, (Object)DefaultScriptPluginFactory.this);
            services.add(ScriptHandlerFactory.class, (Object)DefaultScriptPluginFactory.this.scriptHandlerFactory);
            services.add(ClassLoaderScope.class, (Object)this.targetScope);
            services.add(LoggingManagerInternal.class, DefaultScriptPluginFactory.this.loggingManagerFactory.create());
            services.add(Instantiator.class, (Object)DefaultScriptPluginFactory.this.instantiator);
            services.add(ScriptHandler.class, (Object)this.scriptHandler);
            services.add(FileLookup.class, (Object)DefaultScriptPluginFactory.this.fileLookup);
            ScriptSource withImports = DefaultScriptPluginFactory.this.importsReader.withImports(this.scriptSource);
            PluginDependenciesService pluginDependenciesService = new PluginDependenciesService(this.getSource());
            services.add(PluginDependenciesService.class, (Object)pluginDependenciesService);
            ScriptCompiler compiler = DefaultScriptPluginFactory.this.scriptCompilerFactory.createCompiler(withImports);
            compiler.setClassloader(this.baseScope.getExportClassLoader());
            boolean supportsPluginsBlock = ProjectScript.class.isAssignableFrom(this.scriptType);
            String onPluginBlockError = supportsPluginsBlock ? null : "Only Project build scripts can contain plugins {} blocks";
            PluginsAndBuildscriptTransformer scriptBlockTransformer = new PluginsAndBuildscriptTransformer(this.classpathClosureName, onPluginBlockError, DefaultScriptPluginFactory.this.documentationRegistry);
            StatementExtractingScriptTransformer classpathScriptTransformer = new StatementExtractingScriptTransformer(this.classpathClosureName, scriptBlockTransformer);
            compiler.setTransformer((Transformer)classpathScriptTransformer);
            ScriptRunner<? extends BasicScript> classPathScriptRunner = compiler.compile(this.scriptType);
            classPathScriptRunner.getScript().init(target, (ServiceRegistry)services);
            classPathScriptRunner.run();
            List<PluginRequest> pluginRequests = pluginDependenciesService.getRequests();
            PluginAware pluginAware = target instanceof PluginAware ? (PluginAware)target : null;
            DefaultScriptPluginFactory.this.pluginRequestApplicator.applyPlugins(pluginRequests, this.scriptHandler, pluginAware, this.targetScope);
            compiler.setClassloader(this.targetScope.getLocalClassLoader());
            BuildScriptTransformer transformer = new BuildScriptTransformer("no_" + classpathScriptTransformer.getId(), classpathScriptTransformer.invert(), this.scriptSource);
            compiler.setTransformer(transformer);
            compiler.setVerifier((Verifier)new ClosureCreationInterceptingVerifier());
            ScriptRunner<? extends BasicScript> runner = compiler.compile(this.scriptType);
            BasicScript script = runner.getScript();
            script.init(target, (ServiceRegistry)services);
            if (this.ownerScript && target instanceof ScriptAware) {
                ((ScriptAware)target).setScript(script);
            }
            runner.run();
        }
    }
}

