/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.ui;

import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.theoryinpractice.testng.model.TestNodeDescriptor;
import com.theoryinpractice.testng.model.TestProxy;
import com.theoryinpractice.testng.model.TreeRootNode;
import com.theoryinpractice.testng.ui.Animator;
import com.theoryinpractice.testng.ui.TestNGResults;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.testng.remote.strprotocol.TestResultMessage;

public class ResultTreeRenderer
extends ColoredTreeCellRenderer {
    private TestFrameworkRunningModel model;

    public ResultTreeRenderer(TestFrameworkRunningModel model) {
        this.model = model;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getUserObject() instanceof TestNodeDescriptor) {
            TestProxy proxy = (TestProxy)((TestNodeDescriptor)((Object)node.getUserObject())).getElement();
            if (node == tree.getModel().getRoot()) {
                TreeRootNode root = (TreeRootNode)proxy;
                if (node.getChildCount() == 0 && !((TestNGResults)this.model).hasFinishedTests()) {
                    if (root.isStarted() && root.isInProgress() || root.isInProgress() && !root.isStarted()) {
                        this.setIcon(PoolOfTestIcons.NOT_RAN);
                        this.append("Instantiating tests... ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else if (root.isStarted() && !root.isInProgress()) {
                        this.setIcon(PoolOfTestIcons.PASSED_ICON);
                        this.append("All Tests Passed.", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else {
                        this.setIcon(PoolOfTestIcons.NOT_RAN);
                        this.append("No Test Results.", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                } else {
                    this.setIcon(root.isInProgress() ? Animator.getCurrentFrame() : this.getIcon(proxy));
                    this.append(root.isInProgress() ? "Running tests..." : "Test Results", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                if (this.model.getProperties().isPaused()) {
                    this.setIcon(AllIcons.RunConfigurations.TestPaused);
                }
            } else {
                if (proxy.getResultMessage() != null) {
                    TestResultMessage result = proxy.getResultMessage();
                    String name = TestProxy.toDisplayText(result, this.model.getProperties().getProject());
                    this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else {
                    this.append(proxy.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                this.setIcon(proxy.isInProgress() ? Animator.getCurrentFrame() : (proxy.isInterrupted() ? PoolOfTestIcons.NOT_RAN : this.getIcon(proxy)));
            }
        } else {
            this.setIcon(Animator.getCurrentFrame());
            this.append(node.getUserObject() != null ? node.getUserObject().toString() : "null", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    private Icon getIcon(TestProxy node) {
        if (node.isResult()) {
            TestResultMessage result = node.getResultMessage();
            switch (result.getResult()) {
                case 1001: {
                    if (node.isTearDownFailure()) {
                        return PoolOfTestIcons.TEAR_DOWN_FAILURE;
                    }
                    return PoolOfTestIcons.PASSED_ICON;
                }
                case 1003: {
                    return PoolOfTestIcons.IGNORED_ICON;
                }
                case 1002: {
                    return PoolOfTestIcons.FAILED_ICON;
                }
                case 1016: {
                    return PoolOfTestIcons.TERMINATED_ICON;
                }
            }
        } else {
            if (node.getChildCount() == 0) {
                TestProxy nodeParent = node.getParent();
                if (nodeParent != null && nodeParent.isTearDownFailure()) {
                    TestResultMessage resultMessage = nodeParent.getResultMessage();
                    if (resultMessage != null && resultMessage.getResult() == 1001) {
                        return PoolOfTestIcons.FAILED_ICON;
                    }
                    return PoolOfTestIcons.IGNORED_ICON;
                }
                return PoolOfTestIcons.NOT_RAN;
            }
            boolean hasFail = false;
            boolean hasSkipped = false;
            boolean hasTerminated = false;
            boolean hasTearDownFailure = false;
            for (TestProxy result : node.getChildren()) {
                Icon icon = this.getIcon(result);
                if (icon == PoolOfTestIcons.FAILED_ICON) {
                    hasFail = true;
                    continue;
                }
                if (icon == PoolOfTestIcons.IGNORED_ICON) {
                    hasSkipped = true;
                    continue;
                }
                if (icon == PoolOfTestIcons.TERMINATED_ICON) {
                    hasTerminated = true;
                    continue;
                }
                if (!result.isTearDownFailure()) continue;
                hasTearDownFailure = true;
            }
            if (hasTerminated) {
                return PoolOfTestIcons.TERMINATED_ICON;
            }
            if (hasFail) {
                return PoolOfTestIcons.FAILED_ICON;
            }
            if (hasSkipped) {
                return PoolOfTestIcons.IGNORED_ICON;
            }
            if (hasTearDownFailure) {
                return PoolOfTestIcons.TEAR_DOWN_FAILURE;
            }
        }
        return PoolOfTestIcons.PASSED_ICON;
    }
}

