/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importer;

import com.intellij.application.options.ImportSchemeChooserDialog;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThrowableConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.importer.EclipseCodeStyleImportWorker;
import org.jetbrains.idea.eclipse.importer.EclipseXmlProfileElements;
import org.jetbrains.idea.eclipse.importer.EclipseXmlProfileReader;

public class EclipseCodeStyleSchemeImporter
implements SchemeImporter<CodeStyleScheme>,
EclipseXmlProfileElements {
    @NotNull
    public String[] getSourceExtensions() {
        String[] stringArray = new String[]{"xml"};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "getSourceExtensions"));
        }
        return stringArray;
    }

    @Nullable
    public CodeStyleScheme importScheme(@NotNull Project project, @NotNull VirtualFile selectedFile, CodeStyleScheme currentScheme, SchemeFactory<CodeStyleScheme> schemeFactory) throws SchemeImportException {
        CodeStyleScheme scheme;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "importScheme"));
        }
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "importScheme"));
        }
        String[] schemeNames = this.readSchemeNames(selectedFile);
        final ImportSchemeChooserDialog schemeChooserDialog = new ImportSchemeChooserDialog(project, schemeNames, !currentScheme.isDefault() ? currentScheme.getName() : null);
        if (!schemeChooserDialog.showAndGet()) {
            return null;
        }
        CodeStyleScheme codeStyleScheme = scheme = schemeChooserDialog.isUseCurrentScheme() && !currentScheme.isDefault() ? currentScheme : (CodeStyleScheme)schemeFactory.createNewScheme(schemeChooserDialog.getTargetName());
        if (scheme == null) {
            return null;
        }
        EclipseCodeStyleSchemeImporter.readFromStream(selectedFile, new ThrowableConsumer<InputStream, SchemeImportException>(){

            public void consume(InputStream stream) throws SchemeImportException {
                new EclipseCodeStyleImportWorker().importScheme(stream, schemeChooserDialog.getSelectedName(), scheme);
            }
        });
        return scheme;
    }

    @Nullable
    public String getAdditionalImportInfo(CodeStyleScheme scheme) {
        return null;
    }

    @NotNull
    private String[] readSchemeNames(@NotNull VirtualFile selectedFile) throws SchemeImportException {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "readSchemeNames"));
        }
        final HashSet names = new HashSet();
        final EclipseXmlProfileReader reader = new EclipseXmlProfileReader(new EclipseXmlProfileReader.OptionHandler(){

            @Override
            public void handleOption(@NotNull String eclipseKey, @NotNull String value) throws SchemeImportException {
                if (eclipseKey == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eclipseKey", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter$2", "handleOption"));
                }
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter$2", "handleOption"));
                }
            }

            @Override
            public void handleName(String name) {
                names.add(name);
            }
        });
        EclipseCodeStyleSchemeImporter.readFromStream(selectedFile, new ThrowableConsumer<InputStream, SchemeImportException>(){

            public void consume(InputStream stream) throws SchemeImportException {
                reader.readSettings(stream);
            }
        });
        String[] stringArray = ArrayUtil.toStringArray(names);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "readSchemeNames"));
        }
        return stringArray;
    }

    private static void readFromStream(@NotNull VirtualFile file, @NotNull ThrowableConsumer<InputStream, SchemeImportException> consumer) throws SchemeImportException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "readFromStream"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "readFromStream"));
        }
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            consumer.consume((Object)inputStream);
        }
        catch (IOException e) {
            throw new SchemeImportException((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

