/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FileSeparatorProvider {
    @Nullable
    public static List<LineMarkerInfo> getFileSeparators(PsiFile file, Document document) {
        ArrayList<LineMarkerInfo> result = new ArrayList<LineMarkerInfo>();
        LineMarkersPass pass = new LineMarkersPass(file.getProject(), file, null, document, file.getTextRange());
        for (LineMarkerInfo lineMarkerInfo : pass.queryLineMarkers()) {
            if (lineMarkerInfo.separatorColor == null) continue;
            result.add(lineMarkerInfo);
        }
        Collections.sort(result, new Comparator<LineMarkerInfo>(){

            @Override
            public int compare(LineMarkerInfo i1, LineMarkerInfo i2) {
                return i1.startOffset - i2.startOffset;
            }
        });
        return result;
    }
}

