/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoComponent;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowParameterInfoContext
implements CreateParameterInfoContext {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final Project myProject;
    private final int myOffset;
    private final int myParameterListStart;
    private PsiElement myHighlightedElement;
    private Object[] myItems;

    public ShowParameterInfoContext(Editor editor, Project project, PsiFile file, int offset, int parameterListStart) {
        this.myEditor = editor;
        this.myProject = project;
        this.myFile = file;
        this.myParameterListStart = parameterListStart;
        this.myOffset = offset;
    }

    public Project getProject() {
        return this.myProject;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getParameterListStart() {
        return this.myParameterListStart;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ShowParameterInfoContext", "getEditor"));
        }
        return editor;
    }

    public PsiElement getHighlightedElement() {
        return this.myHighlightedElement;
    }

    public void setHighlightedElement(PsiElement element) {
        this.myHighlightedElement = element;
    }

    public void setItemsToShow(Object[] items) {
        this.myItems = items;
    }

    public Object[] getItemsToShow() {
        return this.myItems;
    }

    public void showHint(PsiElement element, int offset, ParameterInfoHandler handler) {
        Object[] itemsToShow = this.getItemsToShow();
        if (itemsToShow == null || itemsToShow.length == 0) {
            return;
        }
        ShowParameterInfoContext.showMethodInfo(this.getProject(), this.getEditor(), element, this.getHighlightedElement(), itemsToShow, offset, handler);
    }

    private static void showParameterHint(PsiElement element, final Editor editor, Object[] descriptors, final Project project, @Nullable PsiElement highlighted, final int elementStart, final ParameterInfoHandler handler) {
        if (ParameterInfoController.isAlreadyShown(editor, elementStart)) {
            return;
        }
        if (editor.isDisposed() || !editor.getComponent().isVisible()) {
            return;
        }
        ParameterInfoComponent component = new ParameterInfoComponent(descriptors, editor, handler);
        component.setParameterOwner(element);
        if (highlighted != null) {
            component.setHighlightedParameter(highlighted);
        }
        component.update();
        final LightweightHint hint = new LightweightHint(component);
        hint.setSelectingHint(true);
        final HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        final MyBestLocationPointProvider provider = new MyBestLocationPointProvider(editor);
        final Pair<Point, Short> pos = provider.getBestPointPosition(hint, element, elementStart, true, (short)2);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (editor.isDisposed()) {
                    return;
                }
                Document document = editor.getDocument();
                if (document.getTextLength() < elementStart) {
                    return;
                }
                HintHint hintHint = HintManagerImpl.createHintHint(editor, (Point)pos.getFirst(), hint, (Short)pos.getSecond());
                hintHint.setExplicitClose(true);
                Editor editorToShow = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
                hintManager.showEditorHint(hint, editorToShow, (Point)pos.getFirst(), 129, 0, false, hintHint);
                new ParameterInfoController(project, editor, elementStart, hint, handler, provider);
            }
        });
    }

    private static void showMethodInfo(Project project, Editor editor, PsiElement list, PsiElement highlighted, Object[] candidates, int offset, ParameterInfoHandler handler) {
        ShowParameterInfoContext.showParameterHint(list, editor, candidates, project, (PsiElement)(candidates.length > 1 ? highlighted : null), offset, handler);
    }

    static Pair<Point, Short> chooseBestHintPosition(Project project, Editor editor, int line, int col, LightweightHint hint, boolean awtTooltip, short preferredPosition) {
        int underSpace;
        int aboveSpace;
        boolean p2Ok;
        Point p2;
        Point p1;
        boolean isLookupShown;
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        Dimension hintSize = hint.getComponent().getPreferredSize();
        JComponent editorComponent = editor.getComponent();
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        boolean bl = isLookupShown = LookupManager.getInstance(project).getActiveLookup() != null;
        if (isLookupShown) {
            p1 = hintManager.getHintPosition(hint, editor, (short)2);
            p2 = hintManager.getHintPosition(hint, editor, (short)1);
        } else {
            LogicalPosition pos = new LogicalPosition(line, col);
            p1 = HintManagerImpl.getHintPosition(hint, editor, pos, (short)2);
            p2 = HintManagerImpl.getHintPosition(hint, editor, pos, (short)1);
        }
        if (!awtTooltip) {
            p1.x = Math.min(p1.x, layeredPane.getWidth() - hintSize.width);
            p1.x = Math.max(p1.x, 0);
            p2.x = Math.min(p2.x, layeredPane.getWidth() - hintSize.width);
            p2.x = Math.max(p2.x, 0);
        }
        boolean p1Ok = p1.y + hintSize.height < layeredPane.getHeight();
        boolean bl2 = p2Ok = p2.y >= 0;
        if (isLookupShown) {
            if (p1Ok) {
                return new Pair((Object)p1, (Object)2);
            }
            if (p2Ok) {
                return new Pair((Object)p2, (Object)1);
            }
        } else {
            if (preferredPosition != 6) {
                if (preferredPosition == 1) {
                    if (p2Ok) {
                        return new Pair((Object)p2, (Object)1);
                    }
                } else if (preferredPosition == 2 && p1Ok) {
                    return new Pair((Object)p1, (Object)2);
                }
            }
            if (p1Ok) {
                return new Pair((Object)p1, (Object)2);
            }
            if (p2Ok) {
                return new Pair((Object)p2, (Object)1);
            }
        }
        return (aboveSpace = p2.y) > (underSpace = layeredPane.getHeight() - p1.y) ? new Pair((Object)new Point(p2.x, 0), (Object)2) : new Pair((Object)p1, (Object)1);
    }

    static class MyBestLocationPointProvider
    implements ShowParameterInfoHandler.BestLocationPointProvider {
        private final Editor myEditor;
        private int previousOffset = -1;
        private Point previousBestPoint;
        private Short previousBestPosition;

        public MyBestLocationPointProvider(Editor editor) {
            this.myEditor = editor;
        }

        @Override
        @NotNull
        public Pair<Point, Short> getBestPointPosition(LightweightHint hint, PsiElement list, int offset, boolean awtTooltip, short preferredPosition) {
            Pair position;
            TextRange textRange = list.getTextRange();
            int n = offset = textRange.contains(offset) ? offset : textRange.getStartOffset() + 1;
            if (this.previousOffset == offset) {
                Pair pair = Pair.create((Object)this.previousBestPoint, (Object)this.previousBestPosition);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ShowParameterInfoContext$MyBestLocationPointProvider", "getBestPointPosition"));
                }
                return pair;
            }
            String listText = list.getText();
            boolean isMultiline = listText.indexOf(10) >= 0 || listText.indexOf(13) >= 0;
            LogicalPosition pos = this.myEditor.offsetToLogicalPosition(offset);
            if (!isMultiline) {
                position = ShowParameterInfoContext.chooseBestHintPosition(this.myEditor.getProject(), this.myEditor, pos.line, pos.column, hint, awtTooltip, preferredPosition);
            } else {
                Point p = HintManagerImpl.getHintPosition(hint, this.myEditor, pos, (short)1);
                position = new Pair((Object)p, (Object)1);
            }
            this.previousBestPoint = (Point)position.getFirst();
            this.previousBestPosition = (Short)position.getSecond();
            this.previousOffset = offset;
            Pair pair = position;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ShowParameterInfoContext$MyBestLocationPointProvider", "getBestPointPosition"));
            }
            return pair;
        }
    }
}

