/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

public class TypeOfVariableMacro
extends Macro {
    public String getName() {
        return "typeOfVariable";
    }

    public String getPresentableName() {
        return "typeOfVariable(VAR)";
    }

    @NotNull
    public String getDefaultValue() {
        if ("A" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/TypeOfVariableMacro", "getDefaultValue"));
        }
        return "A";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/TypeOfVariableMacro", "calculateResult"));
        }
        if (params.length == 0) {
            return null;
        }
        Project project = context.getProject();
        Result result = params[0].calculateQuickResult(context);
        if (result instanceof PsiElementResult) {
            PsiElement element = ((PsiElementResult)result).getElement();
            if (element instanceof PsiVariable) {
                return new PsiTypeResult(((PsiVariable)element).getType(), project);
            }
        } else if (result instanceof TextResult) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
            PsiElement place = file.findElementAt(context.getStartOffset());
            PsiVariable[] vars = MacroUtil.getVariablesVisibleAt(place, "");
            String name = result.toString();
            for (PsiVariable var : vars) {
                if (!name.equals(var.getName())) continue;
                return new PsiTypeResult(var.getType(), project);
            }
        }
        return null;
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/TypeOfVariableMacro", "calculateQuickResult"));
        }
        return this.calculateResult(params, context);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

