/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluator;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.Nullable;

public abstract class EvaluationDescriptor
extends ValueDescriptorImpl {
    private Modifier myModifier;
    protected TextWithImports myText;

    protected EvaluationDescriptor(TextWithImports text, Project project, Value value) {
        super(project, value);
        this.myText = text;
    }

    protected EvaluationDescriptor(TextWithImports text, Project project) {
        super(project);
        this.setLvalue(false);
        this.myText = text;
    }

    protected abstract EvaluationContextImpl getEvaluationContext(EvaluationContextImpl var1);

    protected abstract PsiCodeFragment getEvaluationCode(StackFrameContext var1) throws EvaluateException;

    public PsiCodeFragment createCodeFragment(PsiElement context) {
        TextWithImports text = this.getEvaluationText();
        JavaCodeFragment fragment = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text, context).createCodeFragment(text, context, this.myProject);
        fragment.forceResolveScope(GlobalSearchScope.allScope((Project)this.myProject));
        return fragment;
    }

    @Override
    public final Value calcValue(final EvaluationContextImpl evaluationContext) throws EvaluateException {
        try {
            ExpressionEvaluator evaluator;
            EvaluationContextImpl thisEvaluationContext;
            block10: {
                thisEvaluationContext = this.getEvaluationContext(evaluationContext);
                evaluator = null;
                try {
                    evaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, new EvaluatingComputable<ExpressionEvaluator>(){

                        @Override
                        public ExpressionEvaluator compute() throws EvaluateException {
                            PsiElement psiContext = PositionUtil.getContextElement((StackFrameContext)evaluationContext);
                            return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(EvaluationDescriptor.this.getEvaluationText(), psiContext).getEvaluatorBuilder().build((PsiElement)EvaluationDescriptor.this.getEvaluationCode((StackFrameContext)thisEvaluationContext), ContextUtil.getSourcePosition((StackFrameContext)thisEvaluationContext));
                        }
                    });
                }
                catch (UnsupportedExpressionException ex) {
                    if (Registry.is((String)"debugger.compiling.evaluator")) {
                        evaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, new EvaluatingComputable<ExpressionEvaluator>(){

                            @Override
                            public ExpressionEvaluator compute() throws EvaluateException {
                                PsiElement psiContext = PositionUtil.getContextElement((StackFrameContext)evaluationContext);
                                if (psiContext == null) {
                                    return null;
                                }
                                PsiFile psiFile = psiContext.getContainingFile();
                                PsiCodeFragment fragment = EvaluationDescriptor.this.createCodeFragment(psiContext);
                                try {
                                    ExtractLightMethodObjectHandler.ExtractedData data = ExtractLightMethodObjectHandler.extractLightMethodObject(EvaluationDescriptor.this.myProject, psiFile, fragment, CompilingEvaluator.getGeneratedClassName());
                                    if (data != null) {
                                        return new CompilingEvaluatorImpl(psiContext, data);
                                    }
                                }
                                catch (PrepareFailedException e) {
                                    NodeDescriptorImpl.LOG.info((Throwable)e);
                                }
                                return null;
                            }
                        });
                    }
                    if (evaluator != null) break block10;
                    throw ex;
                }
            }
            if (!thisEvaluationContext.getDebugProcess().isAttached()) {
                throw EvaluateExceptionUtil.PROCESS_EXITED;
            }
            StackFrameProxyImpl frameProxy = thisEvaluationContext.getFrameProxy();
            if (frameProxy == null) {
                throw EvaluateExceptionUtil.NULL_STACK_FRAME;
            }
            Value value = evaluator.evaluate((EvaluationContext)thisEvaluationContext);
            if (value instanceof ObjectReference) {
                ObjectReference objRef = (ObjectReference)value;
                if (VirtualMachineProxyImpl.isCollected(objRef)) {
                    throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
                }
                thisEvaluationContext.getSuspendContext().keep(objRef);
            }
            this.myModifier = evaluator.getModifier();
            this.setLvalue(this.myModifier != null);
            return value;
        }
        catch (EvaluateException ex) {
            throw new EvaluateException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        catch (ObjectCollectedException ex) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiCodeFragment evaluationCode = this.getEvaluationCode((StackFrameContext)context);
        if (evaluationCode instanceof PsiExpressionCodeFragment) {
            return ((PsiExpressionCodeFragment)evaluationCode).getExpression();
        }
        throw new EvaluateException(DebuggerBundle.message((String)"error.cannot.create.expression.from.code.fragment", (Object[])new Object[0]), null);
    }

    @Nullable
    public Modifier getModifier() {
        return this.myModifier;
    }

    @Override
    public boolean canSetValue() {
        return super.canSetValue() && this.myModifier != null && this.myModifier.canSetValue();
    }

    public TextWithImports getEvaluationText() {
        return this.myText;
    }
}

