/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.AboutPopup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WindowManager;
import java.awt.Window;
import org.jetbrains.annotations.Nullable;

public class AboutAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(!SystemInfo.isMacSystemMenu || !"MainMenu".equals(e.getPlace()));
        e.getPresentation().setDescription("Show information about " + ApplicationNamesInfo.getInstance().getFullProductName());
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Window window = WindowManager.getInstance().suggestParentWindow(project);
        AboutAction.showAboutDialog(window);
    }

    public static void showAbout() {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        Window window = WindowManager.getInstance().suggestParentWindow(project);
        AboutAction.showAboutDialog(window);
    }

    private static void showAboutDialog(@Nullable Window window) {
        new AboutPopup().show(window);
    }
}

