/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.javadoc.JavadocConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="JavadocGenerationManager", storages={@Storage(file="$PROJECT_FILE$")})
public final class JavadocGenerationManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javadoc.JavadocGenerationManager");
    private final JavadocConfiguration myConfiguration;
    private final Project myProject;

    public static JavadocGenerationManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javadoc/JavadocGenerationManager", "getInstance"));
        }
        return (JavadocGenerationManager)ServiceManager.getService((Project)project, JavadocGenerationManager.class);
    }

    JavadocGenerationManager(Project project) {
        this.myProject = project;
        this.myConfiguration = new JavadocConfiguration(project);
    }

    public Element getState() {
        Element state = new Element("state");
        try {
            this.myConfiguration.writeExternal(state);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return state;
    }

    public void loadState(Element state) {
        try {
            this.myConfiguration.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public JavadocConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    public void generateJavadoc(AnalysisScope scope) {
        this.myConfiguration.setGenerationScope(scope);
        try {
            ExecutionEnvironmentBuilder.create((Project)this.myProject, (Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunProfile)this.myConfiguration).buildAndExecute();
        }
        catch (ExecutionException e) {
            ExecutionErrorDialog.show((ExecutionException)e, (String)CommonBundle.getErrorTitle(), (Project)this.myProject);
        }
    }
}

