/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.AbstractMappingStrategy;
import com.intellij.openapi.editor.impl.softwrap.mapping.CacheEntry;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.FoldingData;
import com.intellij.openapi.editor.impl.softwrap.mapping.TabData;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class LogicalToVisualMappingStrategy
extends AbstractMappingStrategy<VisualPosition> {
    private LogicalPosition myTargetLogical;

    LogicalToVisualMappingStrategy(@NotNull LogicalPosition logical, @NotNull EditorEx editor, @NotNull SoftWrapsStorage storage, @NotNull List<CacheEntry> cache) throws IllegalStateException {
        if (logical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logical", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToVisualMappingStrategy", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToVisualMappingStrategy", "<init>"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToVisualMappingStrategy", "<init>"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToVisualMappingStrategy", "<init>"));
        }
        super(editor, storage, cache);
        this.myTargetLogical = logical;
    }

    public void init(@NotNull LogicalPosition logical, @NotNull List<CacheEntry> cache) {
        if (logical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logical", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToVisualMappingStrategy", "init"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToVisualMappingStrategy", "init"));
        }
        this.reset();
        this.myTargetLogical = logical;
        int start = 0;
        int end = cache.size() - 1;
        while (start <= end) {
            int i = end + start >>> 1;
            CacheEntry cacheEntry = cache.get(i);
            if (cacheEntry.endLogicalLine < logical.line || cacheEntry.endLogicalLine == logical.line && this.myStorage.getSoftWrap(cacheEntry.endOffset) != null && cacheEntry.endLogicalColumn <= logical.column) {
                start = i + 1;
                continue;
            }
            if (cacheEntry.startLogicalLine > logical.line || cacheEntry.startLogicalLine == logical.line && cacheEntry.startLogicalColumn > logical.column) {
                end = i - 1;
                continue;
            }
            if (cacheEntry.endLogicalLine == logical.line && cacheEntry.endLogicalColumn == logical.column && i < cache.size() - 1) {
                CacheEntry nextLineCacheEntry = cache.get(i + 1);
                if (nextLineCacheEntry.startLogicalLine == logical.line && nextLineCacheEntry.startLogicalColumn == logical.column) {
                    this.setInitialPosition(nextLineCacheEntry.buildStartLinePosition());
                    return;
                }
            }
            this.setInitialPosition(cacheEntry.buildStartLinePosition());
            return;
        }
        throw new IllegalStateException(String.format("Can't map logical position (%s) to visual position. Reason: no cached information information about target visual line is found. Registered entries: %s", logical, cache));
    }

    @Override
    protected VisualPosition buildIfExceeds(EditorPosition position, int offset) {
        if (position.logicalLine < this.myTargetLogical.line) {
            return null;
        }
        int diff = this.myTargetLogical.column - position.logicalColumn;
        if (offset - position.offset < diff) {
            return null;
        }
        position.visualColumn += diff;
        return position.buildVisualPosition();
    }

    @Override
    protected VisualPosition buildIfExceeds(@NotNull EditorPosition context, @NotNull FoldRegion foldRegion) {
        int foldEndColumn;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToVisualMappingStrategy", "buildIfExceeds"));
        }
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToVisualMappingStrategy", "buildIfExceeds"));
        }
        int foldEndLine = this.myEditor.getDocument().getLineNumber(foldRegion.getEndOffset());
        if (this.myTargetLogical.line > foldEndLine) {
            return null;
        }
        if (this.myTargetLogical.line < foldEndLine) {
            return context.buildVisualPosition();
        }
        FoldingData data = this.getFoldRegionData(foldRegion);
        if (data == null) {
            int xStart = this.myEditor.getDocument().getLineNumber(foldRegion.getStartOffset()) == foldEndLine ? context.x : 0;
            foldEndColumn = SoftWrapModelImpl.getEditorTextRepresentationHelper(this.myEditor).toVisualColumnSymbolsNumber(foldRegion.getStartOffset(), foldRegion.getEndOffset(), xStart);
        } else {
            foldEndColumn = data.getCollapsedSymbolsWidthInColumns();
        }
        if (foldEndLine == context.logicalLine) {
            foldEndColumn += context.logicalColumn;
        }
        if (foldEndColumn <= this.myTargetLogical.column) {
            return null;
        }
        return context.buildVisualPosition();
    }

    @Override
    protected VisualPosition buildIfExceeds(EditorPosition context, TabData tabData) {
        if (context.logicalLine < this.myTargetLogical.line) {
            return null;
        }
        int diff = this.myTargetLogical.column - context.logicalColumn;
        if (diff >= tabData.widthInColumns) {
            return null;
        }
        context.logicalColumn += diff;
        context.visualColumn += diff;
        return context.buildVisualPosition();
    }

    @Override
    public VisualPosition processSoftWrap(@NotNull EditorPosition position, SoftWrap softWrap) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToVisualMappingStrategy", "processSoftWrap"));
        }
        position.visualColumn = softWrap.getIndentInColumns();
        position.softWrapColumnDiff += softWrap.getIndentInColumns();
        if (position.logicalLine < this.myTargetLogical.line || position.logicalColumn != this.myTargetLogical.column) {
            return null;
        }
        return position.buildVisualPosition();
    }

    @Override
    @NotNull
    public VisualPosition build(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToVisualMappingStrategy", "build"));
        }
        int diff = this.myTargetLogical.column - position.logicalColumn;
        position.logicalColumn += diff;
        position.visualColumn += diff;
        position.offset += diff;
        VisualPosition visualPosition = position.buildVisualPosition();
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToVisualMappingStrategy", "build"));
        }
        return visualPosition;
    }
}

