/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import icons.ExternalSystemIcons;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemKeymapExtension
implements KeymapExtension {
    public KeymapGroup createGroup(Condition<AnAction> condition, Project project) {
        KeymapGroup result = KeymapGroupFactory.getInstance().createGroup(ExternalSystemBundle.message((String)"external.system.keymap.group", (Object[])new Object[0]), ExternalSystemIcons.TaskGroup);
        if (project == null) {
            return result;
        }
        MultiMap projectToActionsMapping = MultiMap.create();
        ActionManager actionManager = ActionManager.getInstance();
        for (String eachId : actionManager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project, null))) {
            AnAction eachAction = actionManager.getAction(eachId);
            if (!(eachAction instanceof MyExternalSystemAction) || condition != null && !condition.value((Object)actionManager.getActionOrStub(eachId))) continue;
            MyExternalSystemAction taskAction = (MyExternalSystemAction)eachAction;
            projectToActionsMapping.putValue((Object)Pair.create((Object)taskAction.getSystemId(), (Object)taskAction.getGroup()), (Object)eachId);
        }
        HashMap keymapGroupMap = ContainerUtil.newHashMap();
        for (Pair pair : projectToActionsMapping.keySet()) {
            if (keymapGroupMap.containsKey(pair.first)) continue;
            Icon projectIcon = ExternalSystemUiUtil.getUiAware((ProjectSystemId)pair.first).getProjectIcon();
            KeymapGroup group = KeymapGroupFactory.getInstance().createGroup(((ProjectSystemId)pair.first).getReadableName(), projectIcon);
            result.addGroup(group);
            keymapGroupMap.put(pair.first, group);
        }
        for (Map.Entry each : projectToActionsMapping.entrySet()) {
            String groupName = (String)((Pair)each.getKey()).second;
            Collection tasks = (Collection)each.getValue();
            if (tasks.isEmpty()) continue;
            KeymapGroup group = KeymapGroupFactory.getInstance().createGroup(groupName, ExternalSystemIcons.TaskGroup);
            KeymapGroup systemGroup = (KeymapGroup)keymapGroupMap.get(((Pair)each.getKey()).first);
            if (systemGroup != null) {
                systemGroup.addGroup(group);
            } else {
                result.addGroup(group);
            }
            for (String actionId : tasks) {
                group.addActionId(actionId);
            }
        }
        return result;
    }

    public static void updateActions(Project project, Collection<DataNode<TaskData>> taskData) {
        ExternalSystemKeymapExtension.clearActions(project, taskData);
        ExternalSystemKeymapExtension.createActions(project, taskData);
    }

    private static void createActions(Project project, Collection<DataNode<TaskData>> taskData) {
        ActionManager manager = ActionManager.getInstance();
        for (DataNode<TaskData> each : taskData) {
            DataNode moduleData = ExternalSystemApiUtil.findParent(each, (Key)ProjectKeys.MODULE);
            if (moduleData == null) continue;
            ExternalSystemTaskAction eachAction = new ExternalSystemTaskAction(project, ((ModuleData)moduleData.getData()).getInternalName(), (TaskData)each.getData());
            manager.unregisterAction(eachAction.getId());
            manager.registerAction(eachAction.getId(), (AnAction)eachAction);
        }
    }

    public static void clearActions(Project project) {
        ActionManager manager = ActionManager.getInstance();
        for (String each : manager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project, null))) {
            manager.unregisterAction(each);
        }
    }

    public static void clearActions(Project project, Collection<DataNode<TaskData>> taskData) {
        ActionManager manager = ActionManager.getInstance();
        for (DataNode<TaskData> each : taskData) {
            for (String eachAction : manager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project, ((TaskData)each.getData()).getLinkedExternalProjectPath()))) {
                manager.unregisterAction(eachAction);
            }
        }
    }

    public static String getActionPrefix(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemKeymapExtension", "getActionPrefix"));
        }
        return ExternalProjectsManager.getInstance(project).getShortcutsManager().getActionId(path, null);
    }

    public static void updateRunConfigurationActions(Project project, ProjectSystemId systemId) {
        AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(systemId);
        if (configurationType == null) {
            return;
        }
        THashSet settings = new THashSet((Collection)RunManager.getInstance((Project)project).getConfigurationSettingsList((ConfigurationType)configurationType));
        ActionManager manager = ActionManager.getInstance();
        for (RunnerAndConfigurationSettings configurationSettings : settings) {
            ExternalSystemRunConfigurationAction runConfigurationAction = new ExternalSystemRunConfigurationAction(project, configurationSettings);
            String id = runConfigurationAction.getId();
            manager.unregisterAction(id);
            manager.registerAction(id, (AnAction)runConfigurationAction);
        }
    }

    private static class ExternalSystemRunConfigurationAction
    extends MyExternalSystemAction {
        private final String myId;
        private final String myGroup;
        private final RunnerAndConfigurationSettings myConfigurationSettings;
        private final ProjectSystemId systemId;

        public ExternalSystemRunConfigurationAction(Project project, RunnerAndConfigurationSettings configurationSettings) {
            this.myConfigurationSettings = configurationSettings;
            ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)configurationSettings.getConfiguration();
            this.systemId = runConfiguration.getSettings().getExternalSystemId();
            ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(this.systemId);
            this.myGroup = uiAware.getProjectRepresentationName(runConfiguration.getSettings().getExternalProjectPath(), null);
            String actionIdPrefix = ExternalSystemKeymapExtension.getActionPrefix(project, runConfiguration.getSettings().getExternalProjectPath());
            this.myId = actionIdPrefix + configurationSettings.getName();
            Presentation template = this.getTemplatePresentation();
            template.setText(this.myConfigurationSettings.getName(), false);
            template.setIcon(runConfiguration.getIcon());
        }

        @Override
        protected boolean isEnabled(AnActionEvent e) {
            return this.hasProject(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemKeymapExtension$ExternalSystemRunConfigurationAction", "actionPerformed"));
            }
            ProgramRunnerUtil.executeConfiguration(this.getProject(e), this.myConfigurationSettings, DefaultRunExecutor.getRunExecutorInstance());
        }

        public String toString() {
            return this.myConfigurationSettings.toString();
        }

        @Override
        public String getGroup() {
            return this.myGroup;
        }

        @Override
        public ProjectSystemId getSystemId() {
            return this.systemId;
        }

        @Override
        public String getId() {
            return this.myId;
        }
    }

    private static class ExternalSystemTaskAction
    extends MyExternalSystemAction {
        private final String myId;
        private final String myGroup;
        private final TaskData myTaskData;

        public ExternalSystemTaskAction(Project project, String group, TaskData taskData) {
            this.myGroup = group;
            this.myTaskData = taskData;
            this.myId = ExternalSystemKeymapExtension.getActionPrefix(project, taskData.getLinkedExternalProjectPath()) + taskData.getName();
            Presentation template = this.getTemplatePresentation();
            template.setText(this.myTaskData.getName() + " (" + group + ")", false);
            template.setIcon(ExternalSystemIcons.Task);
        }

        @Override
        protected boolean isEnabled(AnActionEvent e) {
            return this.hasProject(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemKeymapExtension$ExternalSystemTaskAction", "actionPerformed"));
            }
            ExternalTaskExecutionInfo taskExecutionInfo = ExternalSystemActionUtil.buildTaskInfo(this.myTaskData);
            ExternalSystemUtil.runTask(taskExecutionInfo.getSettings(), taskExecutionInfo.getExecutorId(), this.getProject(e), this.myTaskData.getOwner());
        }

        public TaskData getTaskData() {
            return this.myTaskData;
        }

        public String toString() {
            return this.myTaskData.toString();
        }

        @Override
        public String getGroup() {
            return this.myGroup;
        }

        @Override
        public ProjectSystemId getSystemId() {
            return this.myTaskData.getOwner();
        }

        @Override
        public String getId() {
            return this.myId;
        }
    }

    private static abstract class MyExternalSystemAction
    extends ExternalSystemAction {
        private MyExternalSystemAction() {
        }

        public abstract String getId();

        public abstract String getGroup();

        public abstract ProjectSystemId getSystemId();
    }
}

