/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.filters.getters.ClassLiteralLookupElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassLiteralGetter {
    public static void addCompletions(@NotNull JavaSmartCompletionParameters parameters, @NotNull Consumer<LookupElement> result, PrefixMatcher matcher) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/filters/getters/ClassLiteralGetter", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/filters/getters/ClassLiteralGetter", "addCompletions"));
        }
        PsiType expectedType = parameters.getDefaultType();
        if (!InheritanceUtil.isInheritor((PsiType)expectedType, (String)"java.lang.Class") && !InheritanceUtil.isInheritor((PsiType)(expectedType = parameters.getExpectedType()), (String)"java.lang.Class")) {
            return;
        }
        PsiType classParameter = PsiUtil.substituteTypeParameter((PsiType)expectedType, (String)"java.lang.Class", (int)0, (boolean)false);
        boolean addInheritors = false;
        PsiElement position = parameters.getPosition();
        if (classParameter instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)classParameter;
            classParameter = wildcardType.isSuper() ? wildcardType.getSuperBound() : wildcardType.getExtendsBound();
            addInheritors = wildcardType.isExtends() && classParameter instanceof PsiClassType;
        } else if (!matcher.getPrefix().isEmpty()) {
            addInheritors = true;
            classParameter = PsiType.getJavaLangObject((PsiManager)position.getManager(), (GlobalSearchScope)position.getResolveScope());
        }
        if (classParameter != null) {
            PsiFile file = position.getContainingFile();
            ClassLiteralGetter.addClassLiteralLookupElement(classParameter, result, file);
            if (addInheritors) {
                ClassLiteralGetter.addInheritorClassLiterals(file, classParameter, result, matcher);
            }
        }
    }

    private static void addInheritorClassLiterals(final PsiFile context, PsiType classParameter, final Consumer<LookupElement> result, PrefixMatcher matcher) {
        String canonicalText = classParameter.getCanonicalText();
        if ("java.lang.Object".equals(canonicalText) && StringUtil.isEmpty((String)matcher.getPrefix())) {
            return;
        }
        CodeInsightUtil.processSubTypes(classParameter, (PsiElement)context, true, matcher, new Consumer<PsiType>(){

            public void consume(PsiType type) {
                ClassLiteralGetter.addClassLiteralLookupElement(type, (Consumer<LookupElement>)result, context);
            }
        });
    }

    private static void addClassLiteralLookupElement(@Nullable PsiType type, Consumer<LookupElement> resultSet, PsiFile context) {
        if (type instanceof PsiClassType && PsiUtil.resolveClassInType((PsiType)type) != null && !((PsiClassType)type).hasParameters() && !(((PsiClassType)type).resolve() instanceof PsiTypeParameter)) {
            try {
                resultSet.consume((Object)AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy((LookupElement)new ClassLiteralLookupElement((PsiClassType)type, (PsiElement)context)));
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
    }
}

