/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaFormatterUtil {
    private static final Set<IElementType> ASSIGNMENT_ELEMENT_TYPES = new HashSet<IElementType>(Arrays.asList(JavaElementType.ASSIGNMENT_EXPRESSION, JavaElementType.LOCAL_VARIABLE, JavaElementType.FIELD));

    private JavaFormatterUtil() {
    }

    public static boolean isAssignment(ASTNode node) {
        return ASSIGNMENT_ELEMENT_TYPES.contains(node.getElementType());
    }

    public static boolean areSamePriorityBinaryExpressions(ASTNode node1, ASTNode node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        if (!(node1 instanceof PsiPolyadicExpression) || !(node2 instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression1 = (PsiPolyadicExpression)node1;
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)node2;
        return expression1.getOperationTokenType() == expression2.getOperationTokenType();
    }

    public static boolean hasMultilineArguments(@NotNull PsiExpression[] arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/formatter/java/JavaFormatterUtil", "hasMultilineArguments"));
        }
        for (PsiExpression argument : arguments) {
            ASTNode node = argument.getNode();
            if (!node.textContains('\n')) continue;
            return true;
        }
        return false;
    }

    public static boolean canHaveMultilineArgumentsAfterWrap(@NotNull PsiExpression[] arguments, @NotNull CommonCodeStyleSettings settings) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/formatter/java/JavaFormatterUtil", "canHaveMultilineArgumentsAfterWrap"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/formatter/java/JavaFormatterUtil", "canHaveMultilineArgumentsAfterWrap"));
        }
        for (PsiExpression argument : arguments) {
            ASTNode node = argument.getNode();
            if (!(node instanceof PsiMethodCallExpression) || !settings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE && !settings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE || ((PsiMethodCallExpression)node).getArgumentList().getExpressions().length <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isMultilineExceptArguments(@NotNull PsiExpression[] arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/formatter/java/JavaFormatterUtil", "isMultilineExceptArguments"));
        }
        for (PsiExpression argument : arguments) {
            ASTNode beforeArgument = argument.getNode().getTreePrev();
            if (!JavaFormatterUtil.isWhiteSpaceWithLineFeed(beforeArgument)) continue;
            return true;
        }
        PsiExpression lastArgument = arguments[arguments.length - 1];
        ASTNode afterLastArgument = lastArgument.getNode().getTreeNext();
        return JavaFormatterUtil.isWhiteSpaceWithLineFeed(afterLastArgument);
    }

    public static boolean canBeMultilineExceptArgumentsAfterWrap(@NotNull PsiExpression[] arguments, @NotNull CommonCodeStyleSettings settings) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/formatter/java/JavaFormatterUtil", "canBeMultilineExceptArgumentsAfterWrap"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/formatter/java/JavaFormatterUtil", "canBeMultilineExceptArgumentsAfterWrap"));
        }
        return arguments.length > 0 && (settings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE || settings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE);
    }

    private static boolean isWhiteSpaceWithLineFeed(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/formatter/java/JavaFormatterUtil", "isWhiteSpaceWithLineFeed"));
        }
        return node instanceof PsiWhiteSpace && node.textContains('\n');
    }

    @NotNull
    public static WrapType getWrapType(int wrap) {
        switch (wrap) {
            case 2: {
                WrapType wrapType = WrapType.ALWAYS;
                if (wrapType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/JavaFormatterUtil", "getWrapType"));
                }
                return wrapType;
            }
            case 1: {
                WrapType wrapType = WrapType.NORMAL;
                if (wrapType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/JavaFormatterUtil", "getWrapType"));
                }
                return wrapType;
            }
            case 0: {
                WrapType wrapType = WrapType.NONE;
                if (wrapType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/JavaFormatterUtil", "getWrapType"));
                }
                return wrapType;
            }
        }
        WrapType wrapType = WrapType.CHOP_DOWN_IF_LONG;
        if (wrapType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/JavaFormatterUtil", "getWrapType"));
        }
        return wrapType;
    }
}

