/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.imports.ImportStatementComparator;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ImportsAreUsedVisitor
extends JavaRecursiveElementVisitor {
    private final PsiJavaFile myFile;
    private final List<PsiImportStatementBase> importStatements;
    private final List<PsiImportStatementBase> usedImportStatements = new ArrayList<PsiImportStatementBase>();

    ImportsAreUsedVisitor(PsiJavaFile file) {
        this.myFile = file;
        PsiImportList importList = file.getImportList();
        if (importList == null) {
            this.importStatements = Collections.emptyList();
        } else {
            PsiImportStatementBase[] importStatements = importList.getAllImportStatements();
            this.importStatements = new ArrayList<PsiImportStatementBase>(Arrays.asList(importStatements));
            Collections.sort(this.importStatements, ImportStatementComparator.getInstance());
        }
    }

    public void visitElement(PsiElement element) {
        if (this.importStatements.isEmpty()) {
            return;
        }
        super.visitElement(element);
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/siyeh/ig/imports/ImportsAreUsedVisitor", "visitReferenceElement"));
        }
        this.followReferenceToImport(reference);
        super.visitReferenceElement(reference);
    }

    private void followReferenceToImport(PsiJavaCodeReferenceElement reference) {
        if (reference.getQualifier() != null) {
            return;
        }
        JavaResolveResult resolveResult = reference.advancedResolve(true);
        PsiElement element = resolveResult.getElement();
        if (!(element instanceof PsiMember)) {
            return;
        }
        PsiMember member = (PsiMember)element;
        if (this.findImport(member, this.usedImportStatements) != null) {
            return;
        }
        PsiImportStatementBase foundImport = this.findImport(member, this.importStatements);
        if (foundImport != null) {
            this.importStatements.remove(foundImport);
            this.usedImportStatements.add(foundImport);
        }
    }

    private PsiImportStatementBase findImport(PsiMember member, List<PsiImportStatementBase> importStatements) {
        String packageName;
        String qualifiedName;
        PsiClass containingClass = member.getContainingClass();
        if (member instanceof PsiClass) {
            PsiClass referencedClass = (PsiClass)member;
            qualifiedName = referencedClass.getQualifiedName();
            packageName = qualifiedName != null ? StringUtil.getPackageName((String)qualifiedName) : null;
        } else {
            if (!member.hasModifierProperty("static") || containingClass == null) {
                return null;
            }
            packageName = containingClass.getQualifiedName();
            qualifiedName = packageName + '.' + member.getName();
        }
        if (packageName == null) {
            return null;
        }
        boolean hasOnDemandImportConflict = ImportUtils.hasOnDemandImportConflict(qualifiedName, (PsiElement)this.myFile);
        for (PsiImportStatementBase importStatement : importStatements) {
            if (!importStatement.isOnDemand()) {
                JavaResolveResult[] targets;
                PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
                if (reference == null) continue;
                for (JavaResolveResult target : targets = reference.multiResolve(false)) {
                    if (!member.equals(target.getElement())) continue;
                    return importStatement;
                }
                continue;
            }
            if (hasOnDemandImportConflict) continue;
            PsiElement target = importStatement.resolve();
            if (target instanceof PsiPackage) {
                PsiPackage aPackage = (PsiPackage)target;
                if (!packageName.equals(aPackage.getQualifiedName())) continue;
                return importStatement;
            }
            if (!(target instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)target;
            if (!(importStatement instanceof PsiImportStaticStatement ? member.hasModifierProperty("static") && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)containingClass, (boolean)true) : importStatement instanceof PsiImportStatement && member instanceof PsiClass && aClass.equals(containingClass))) continue;
            return importStatement;
        }
        return null;
    }

    public PsiImportStatementBase[] getUnusedImportStatements() {
        if (this.importStatements.isEmpty()) {
            return PsiImportStatementBase.EMPTY_ARRAY;
        }
        return this.importStatements.toArray(new PsiImportStatementBase[this.importStatements.size()]);
    }
}

