/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import com.intellij.util.text.CharArrayCharSequence;
import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;

public final class ByteBufUtf8Writer
extends Writer {
    private final ByteBuf buffer;

    public ByteBufUtf8Writer(@NotNull ByteBuf buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "io/netty/buffer/ByteBufUtf8Writer", "<init>"));
        }
        this.buffer = buffer;
    }

    public void write(@NotNull InputStream inputStream, int length) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "io/netty/buffer/ByteBufUtf8Writer", "write"));
        }
        this.buffer.writeBytes(inputStream, length);
    }

    @Override
    public void write(int c) {
        AbstractByteBuf buffer = ByteBufUtilEx.getBuf(this.buffer);
        int writerIndex = this.buffer.writerIndex();
        if (c < 128) {
            buffer._setByte(writerIndex++, (int)((byte)c));
        } else if (c < 2048) {
            buffer._setByte(writerIndex++, (int)((byte)(0xC0 | c >> 6)));
            buffer._setByte(writerIndex++, (int)((byte)(0x80 | c & 0x3F)));
        } else {
            buffer._setByte(writerIndex++, (int)((byte)(0xE0 | c >> 12)));
            buffer._setByte(writerIndex++, (int)((byte)(0x80 | c >> 6 & 0x3F)));
            buffer._setByte(writerIndex++, (int)((byte)(0x80 | c & 0x3F)));
        }
        this.buffer.writerIndex(writerIndex);
    }

    @Override
    public void write(char[] chars, int off, int len) {
        ByteBufUtilEx.writeUtf8(this.buffer, (CharSequence)new CharArrayCharSequence(chars, off, off + len));
    }

    @Override
    public void write(String str) {
        ByteBufUtilEx.writeUtf8(this.buffer, str);
    }

    @Override
    public void write(String str, int off, int len) {
        ByteBufUtilEx.writeUtf8(this.buffer, str, off, off + len);
    }

    @Override
    public Writer append(CharSequence csq) {
        if (csq == null) {
            ByteBufUtil.writeAscii((ByteBuf)this.buffer, (CharSequence)"null");
        } else {
            ByteBufUtilEx.writeUtf8(this.buffer, csq);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) {
        ByteBufUtilEx.writeUtf8(this.buffer, csq, start, end);
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

