/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandSenderBase;
import org.jetbrains.rpc.MessageManager;
import org.jetbrains.rpc.MessageProcessor;
import org.jetbrains.rpc.ResultReader;

public abstract class CommandProcessor<INCOMING, INCOMING_WITH_SEQ, SUCCESS_RESPONSE>
extends CommandSenderBase<SUCCESS_RESPONSE>
implements MessageManager.Handler<Request, INCOMING, INCOMING_WITH_SEQ, SUCCESS_RESPONSE>,
ResultReader<SUCCESS_RESPONSE>,
MessageProcessor {
    public static final Logger LOG = Logger.getInstance(CommandProcessor.class);
    private final AtomicInteger currentSequence = new AtomicInteger();
    protected final MessageManager<Request, INCOMING, INCOMING_WITH_SEQ, SUCCESS_RESPONSE> messageManager = new MessageManager(this);

    protected CommandProcessor() {
    }

    @Override
    public final void cancelWaitingRequests() {
        this.messageManager.cancelWaitingRequests();
    }

    @Override
    public final void closed() {
        this.messageManager.closed();
    }

    @Override
    public final int getUpdatedSequence(@NotNull Request message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/rpc/CommandProcessor", "getUpdatedSequence"));
        }
        int id = this.currentSequence.incrementAndGet();
        message.finalize(id);
        return id;
    }

    @Override
    protected <RESULT> void send(@NotNull Request message, @NotNull CommandSenderBase.RequestPromise<SUCCESS_RESPONSE, RESULT> callback) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/rpc/CommandProcessor", "send"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/rpc/CommandProcessor", "send"));
        }
        this.messageManager.send(message, callback);
    }
}

