/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.ConfigurationFromContextWrapper;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.Extensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreferredProducerFind {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.actions.PreferredProducerFind");

    private PreferredProducerFind() {
    }

    @Nullable
    public static RunnerAndConfigurationSettings createConfiguration(@NotNull Location location, ConfigurationContext context) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/execution/actions/PreferredProducerFind", "createConfiguration"));
        }
        ConfigurationFromContext fromContext = PreferredProducerFind.findConfigurationFromContext(location, context);
        return fromContext != null ? fromContext.getConfigurationSettings() : null;
    }

    @Deprecated
    @Nullable
    public static List<RuntimeConfigurationProducer> findPreferredProducers(Location location, ConfigurationContext context, boolean strict) {
        if (location == null) {
            return null;
        }
        List<RuntimeConfigurationProducer> producers = PreferredProducerFind.findAllProducers(location, context);
        if (producers.isEmpty()) {
            return null;
        }
        Collections.sort(producers, RuntimeConfigurationProducer.COMPARATOR);
        if (strict) {
            RuntimeConfigurationProducer first = producers.get(0);
            Iterator<RuntimeConfigurationProducer> it = producers.iterator();
            while (it.hasNext()) {
                RuntimeConfigurationProducer producer = it.next();
                if (producer == first || RuntimeConfigurationProducer.COMPARATOR.compare(producer, first) < 0) continue;
                it.remove();
            }
        }
        return producers;
    }

    private static List<RuntimeConfigurationProducer> findAllProducers(Location location, ConfigurationContext context) {
        Extensions.getExtensions(ConfigurationType.CONFIGURATION_TYPE_EP);
        RuntimeConfigurationProducer[] configurationProducers = ApplicationManager.getApplication().getExtensions(RuntimeConfigurationProducer.RUNTIME_CONFIGURATION_PRODUCER);
        ArrayList<RuntimeConfigurationProducer> producers = new ArrayList<RuntimeConfigurationProducer>();
        for (RuntimeConfigurationProducer prototype : configurationProducers) {
            RuntimeConfigurationProducer producer;
            try {
                producer = prototype.createProducer(location, context);
            }
            catch (AbstractMethodError e) {
                LOG.error((Throwable)new ExtensionException(prototype.getClass()));
                continue;
            }
            if (producer.getConfiguration() == null) continue;
            LOG.assertTrue(producer.getSourceElement() != null, (Object)producer);
            producers.add(producer);
        }
        return producers;
    }

    public static List<ConfigurationFromContext> getConfigurationsFromContext(Location location, ConfigurationContext context, boolean strict) {
        if (location == null) {
            return null;
        }
        ArrayList<ConfigurationFromContext> configurationsFromContext = new ArrayList<ConfigurationFromContext>();
        for (RuntimeConfigurationProducer runtimeConfigurationProducer : PreferredProducerFind.findAllProducers(location, context)) {
            configurationsFromContext.add(new ConfigurationFromContextWrapper(runtimeConfigurationProducer));
        }
        for (RunConfigurationProducer runConfigurationProducer : RunConfigurationProducer.getProducers(context.getProject())) {
            ConfigurationFromContext fromContext = runConfigurationProducer.findOrCreateConfigurationFromContext(context);
            if (fromContext == null) continue;
            configurationsFromContext.add(fromContext);
        }
        if (configurationsFromContext.isEmpty()) {
            return null;
        }
        Collections.sort(configurationsFromContext, ConfigurationFromContext.COMPARATOR);
        if (strict) {
            ConfigurationFromContext first = configurationsFromContext.get(0);
            Iterator<ConfigurationFromContext> iterator = configurationsFromContext.iterator();
            while (iterator.hasNext()) {
                ConfigurationFromContext producer = iterator.next();
                if (producer == first || ConfigurationFromContext.COMPARATOR.compare(producer, first) <= 0) continue;
                iterator.remove();
            }
        }
        return configurationsFromContext;
    }

    @Nullable
    private static ConfigurationFromContext findConfigurationFromContext(Location location, ConfigurationContext context) {
        List<ConfigurationFromContext> producers = PreferredProducerFind.getConfigurationsFromContext(location, context, true);
        if (producers != null) {
            return producers.get(0);
        }
        return null;
    }
}

