/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlFilter
implements Filter {
    public static final Pattern URL_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+&@#/%?=~_|!:,.;]*[-A-Za-z0-9+&@#/%=~_|]");

    @Override
    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        int textStartOffset = entireLength - line.length();
        Matcher m = URL_PATTERN.matcher(line);
        if (m.find()) {
            return new Filter.Result(textStartOffset + m.start(), textStartOffset + m.end(), new BrowserHyperlinkInfo(m.group()));
        }
        return null;
    }

    public static class UrlFilterProvider
    implements ConsoleFilterProviderEx {
        @Override
        public Filter[] getDefaultFilters(@NotNull Project project, @NotNull GlobalSearchScope scope) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/UrlFilter$UrlFilterProvider", "getDefaultFilters"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/execution/filters/UrlFilter$UrlFilterProvider", "getDefaultFilters"));
            }
            return new Filter[]{new UrlFilter()};
        }

        @Override
        @NotNull
        public Filter[] getDefaultFilters(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/UrlFilter$UrlFilterProvider", "getDefaultFilters"));
            }
            Filter[] filterArray = this.getDefaultFilters(project, GlobalSearchScope.allScope(project));
            if (filterArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/UrlFilter$UrlFilterProvider", "getDefaultFilters"));
            }
            return filterArray;
        }
    }
}

