/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.HelpIdProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentDescriptor
implements Disposable {
    private ExecutionConsole myExecutionConsole;
    private ProcessHandler myProcessHandler;
    private JComponent myComponent;
    private final String myDisplayName;
    private final Icon myIcon;
    private final String myHelpId;
    private RunnerLayoutUi myRunnerLayoutUi;
    private boolean myActivateToolWindowWhenAdded;
    private boolean myReuseToolWindowActivation;
    private long myExecutionId;
    private Computable<JComponent> myFocusComputable;
    private boolean myAutoFocusContent;
    private Content myContent;
    private Runnable myRestarter;
    @NotNull
    private final AnAction[] myRestartActions;
    @Nullable
    private final Runnable myActivationCallback;

    public RunContentDescriptor(@Nullable ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull JComponent component, String displayName, @Nullable Icon icon, @Nullable Runnable activationCallback) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/execution/ui/RunContentDescriptor", "<init>"));
        }
        this(executionConsole, processHandler, component, displayName, icon, activationCallback, null);
    }

    public RunContentDescriptor(@Nullable ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull JComponent component, String displayName, @Nullable Icon icon, @Nullable Runnable activationCallback, @Nullable AnAction[] restartActions) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/execution/ui/RunContentDescriptor", "<init>"));
        }
        this.myRunnerLayoutUi = null;
        this.myActivateToolWindowWhenAdded = true;
        this.myReuseToolWindowActivation = false;
        this.myExecutionId = 0L;
        this.myFocusComputable = null;
        this.myAutoFocusContent = false;
        this.myExecutionConsole = executionConsole;
        this.myProcessHandler = processHandler;
        this.myComponent = component;
        this.myDisplayName = displayName;
        this.myIcon = icon;
        this.myHelpId = this.myExecutionConsole instanceof HelpIdProvider ? ((HelpIdProvider)((Object)this.myExecutionConsole)).getHelpId() : null;
        this.myActivationCallback = activationCallback;
        if (this.myExecutionConsole != null) {
            Disposer.register((Disposable)this, (Disposable)this.myExecutionConsole);
        }
        this.myRestartActions = restartActions == null ? AnAction.EMPTY_ARRAY : restartActions;
    }

    public RunContentDescriptor(@Nullable ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull JComponent component, String displayName, @Nullable Icon icon) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/execution/ui/RunContentDescriptor", "<init>"));
        }
        this(executionConsole, processHandler, component, displayName, icon, null, null);
    }

    public RunContentDescriptor(@Nullable ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull JComponent component, String displayName) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/execution/ui/RunContentDescriptor", "<init>"));
        }
        this(executionConsole, processHandler, component, displayName, null, null, null);
    }

    public RunContentDescriptor(@NotNull RunProfile profile, @NotNull ExecutionResult executionResult, @NotNull RunnerLayoutUi ui) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/execution/ui/RunContentDescriptor", "<init>"));
        }
        if (executionResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionResult", "com/intellij/execution/ui/RunContentDescriptor", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/execution/ui/RunContentDescriptor", "<init>"));
        }
        this(executionResult.getExecutionConsole(), executionResult.getProcessHandler(), ui.getComponent(), profile.getName(), profile.getIcon(), null, executionResult instanceof DefaultExecutionResult ? ((DefaultExecutionResult)executionResult).getRestartActions() : null);
        this.myRunnerLayoutUi = ui;
    }

    public Runnable getActivationCallback() {
        return this.myActivationCallback;
    }

    @NotNull
    public AnAction[] getRestartActions() {
        AnAction[] anActionArray = this.myRestartActions.length == 0 ? AnAction.EMPTY_ARRAY : (AnAction[])this.myRestartActions.clone();
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/RunContentDescriptor", "getRestartActions"));
        }
        return anActionArray;
    }

    public ExecutionConsole getExecutionConsole() {
        return this.myExecutionConsole;
    }

    public void dispose() {
        this.myExecutionConsole = null;
        this.myComponent = null;
        this.myRestarter = null;
        this.myProcessHandler = null;
        this.myContent = null;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public void setProcessHandler(ProcessHandler processHandler) {
        this.myProcessHandler = processHandler;
    }

    public boolean isContentReuseProhibited() {
        return false;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    @Nullable
    public Content getAttachedContent() {
        return this.myContent;
    }

    public void setAttachedContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/RunContentDescriptor", "setAttachedContent"));
        }
        this.myContent = content;
    }

    @Deprecated
    @Nullable
    public Runnable getRestarter() {
        return this.myRestarter;
    }

    @Deprecated
    public void setRestarter(@Nullable Runnable runnable) {
        this.myRestarter = runnable;
    }

    public boolean isActivateToolWindowWhenAdded() {
        return this.myActivateToolWindowWhenAdded;
    }

    public void setActivateToolWindowWhenAdded(boolean activateToolWindowWhenAdded) {
        this.myActivateToolWindowWhenAdded = activateToolWindowWhenAdded;
    }

    public boolean isReuseToolWindowActivation() {
        return this.myReuseToolWindowActivation;
    }

    public void setReuseToolWindowActivation(boolean reuseToolWindowActivation) {
        this.myReuseToolWindowActivation = reuseToolWindowActivation;
    }

    public long getExecutionId() {
        return this.myExecutionId;
    }

    public void setExecutionId(long executionId) {
        this.myExecutionId = executionId;
    }

    public String toString() {
        return this.getClass().getName() + "#" + this.hashCode() + "(" + this.getDisplayName() + ")";
    }

    public Computable<JComponent> getPreferredFocusComputable() {
        return this.myFocusComputable;
    }

    public void setFocusComputable(Computable<JComponent> focusComputable) {
        this.myFocusComputable = focusComputable;
    }

    public boolean isAutoFocusContent() {
        return this.myAutoFocusContent;
    }

    public void setAutoFocusContent(boolean autoFocusContent) {
        this.myAutoFocusContent = autoFocusContent;
    }

    @Nullable
    public RunnerLayoutUi getRunnerLayoutUi() {
        return this.myRunnerLayoutUi;
    }
}

