/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.ssl.CertificateInfoPanel;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.CertificateWrapper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CertificateWarningDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(CertificateWarningDialog.class);
    private JPanel myRootPanel;
    private JLabel myWarningSign;
    private JPanel myCertificateInfoPanel;
    private JTextPane myNoticePane;
    private JTextPane myMessagePane;
    private final X509Certificate myCertificate;

    public static CertificateWarningDialog createUntrustedCertificateWarning(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificate", "com/intellij/util/net/ssl/CertificateWarningDialog", "createUntrustedCertificateWarning"));
        }
        return new CertificateWarningDialog(certificate, "Untrusted Server's Certificate", "Server's certificate is not trusted");
    }

    public static CertificateWarningDialog createExpiredCertificateWarning(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificate", "com/intellij/util/net/ssl/CertificateWarningDialog", "createExpiredCertificateWarning"));
        }
        throw new UnsupportedOperationException("Not supported");
    }

    public static CertificateWarningDialog createHostnameMismatchWarning(@NotNull X509Certificate certificate, @NotNull String hostname) {
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificate", "com/intellij/util/net/ssl/CertificateWarningDialog", "createHostnameMismatchWarning"));
        }
        if (hostname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostname", "com/intellij/util/net/ssl/CertificateWarningDialog", "createHostnameMismatchWarning"));
        }
        String message = String.format("Server's certificate common name doesn't match hostname in URL: '%s' != '%s'", new CertificateWrapper(certificate).getSubjectField(CertificateWrapper.CommonField.COMMON_NAME), hostname);
        return new CertificateWarningDialog(certificate, "Invalid hostname", message);
    }

    public CertificateWarningDialog(@NotNull X509Certificate certificate, @NotNull String title, @NotNull String message) {
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificate", "com/intellij/util/net/ssl/CertificateWarningDialog", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/net/ssl/CertificateWarningDialog", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/util/net/ssl/CertificateWarningDialog", "<init>"));
        }
        super((Project)null, false);
        this.myCertificate = certificate;
        this.$$$setupUI$$$();
        CertificateManager manager = CertificateManager.getInstance();
        this.setTitle(title);
        this.myMessagePane.setText(String.format("<html><body><p>%s</p></body></html>", message));
        this.myMessagePane.setBackground(UIUtil.getPanelBackground());
        this.setOKButtonText("Accept");
        this.setCancelButtonText("Reject");
        this.myWarningSign.setIcon(AllIcons.General.WarningDialog);
        Messages.installHyperlinkSupport(this.myNoticePane);
        String path = FileUtil.toCanonicalPath((String)manager.getCacertsPath());
        String password = manager.getPassword();
        this.myNoticePane.setText(String.format("<html><p>Accepted certificate will be saved in truststore <code>%s</code> with default password <code>%s</code></p><html>", path, password));
        this.myCertificateInfoPanel.add((Component)new CertificateInfoPanel(certificate), "Center");
        this.setResizable(false);
        this.init();
        LOG.debug("Preferred size: " + this.getPreferredSize());
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JLabel jLabel;
        JTextPane jTextPane2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 10, 0, 10), -1, -1, false, false));
        jPanel2.setPreferredSize(new Dimension(550, 650));
        jPanel2.setOpaque(false);
        jPanel2.setMinimumSize(new Dimension(-1, -1));
        this.myCertificateInfoPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 6, 2, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, new Color(-16777216)));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setRequestFocusEnabled(true);
        Font font = jBLabel.getFont();
        jBLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        jBLabel.setText("Certificate details");
        jPanel.add((Component)jBLabel, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myNoticePane = jTextPane2 = new JTextPane();
        jTextPane2.setOpaque(false);
        jTextPane2.setContentType("text/html");
        jTextPane2.setText("<html>\n  <head>\n\n  </head>\n  <body>\n    <p style=\"margin-top: 0\">\n      \n    </p>\n  </body>\n</html>\n");
        jPanel3.add((Component)jTextPane2, new GridConstraints(0, 0, 1, 1, 2, 1, 6, 0, null, new Dimension(50, 50), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myWarningSign = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 2, null, null, null));
        this.myMessagePane = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setOpaque(true);
        jTextPane.setContentType("text/html");
        jPanel2.add((Component)jTextPane, new GridConstraints(0, 1, 1, 1, 0, 3, 6, 2, null, new Dimension(150, 50), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

